/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.microprofile.model;

import com.redhat.microprofile.ls.commons.BadLocationException;
import com.redhat.microprofile.ls.commons.TextDocument;
import com.redhat.microprofile.model.PropertiesModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.eclipse.lsp4j.Position;

public abstract class Node {
    private List<Node> children;
    private int start = -1;
    private int end = -1;
    Node parent;

    public int getStart() {
        return this.start;
    }

    void setStart(int start) {
        this.start = start;
    }

    public int getEnd() {
        return this.end;
    }

    void setEnd(int end) {
        this.end = end;
    }

    public String getText() {
        if (this.start == -1 || this.end == -1) {
            return null;
        }
        return this.getOwnerModel().getText(this.start, this.end, false);
    }

    public String getText(boolean skipMultiLine) {
        if (this.start == -1 || this.end == -1) {
            return null;
        }
        return this.getOwnerModel().getText(this.start, this.end, skipMultiLine);
    }

    public PropertiesModel getOwnerModel() {
        Node parent = this.parent;
        while (parent != null) {
            if (parent.getNodeType() == NodeType.DOCUMENT) {
                return (PropertiesModel)parent;
            }
            parent = parent.parent;
        }
        return null;
    }

    public List<Node> getChildren() {
        return this.children != null ? this.children : Collections.emptyList();
    }

    void addNode(Node node) {
        if (this.children == null) {
            this.children = new ArrayList<Node>();
        }
        node.parent = this;
        this.children.add(node);
    }

    public abstract NodeType getNodeType();

    public TextDocument getDocument() {
        return this.getOwnerModel().getDocument();
    }

    public Node findNodeAt(int offset) {
        Node child;
        List<Node> children = this.getChildren();
        int idx = Node.findFirst(children, c -> offset < c.getStart()) - 1;
        if (idx >= 0 && Node.isIncluded(child = children.get(idx), offset)) {
            return child.findNodeAt(offset);
        }
        return this;
    }

    public static boolean isIncluded(Node node, int offset) {
        if (node == null) {
            return false;
        }
        return Node.isIncluded(node.getStart(), node.getEnd(), offset);
    }

    public static boolean isIncluded(int start, int end, int offset) {
        return offset >= start && offset <= end;
    }

    private static <T> int findFirst(List<T> array, Function<T, Boolean> p) {
        int low = 0;
        int high = array.size();
        if (high == 0) {
            return 0;
        }
        while (low < high) {
            int mid = (int)Math.floor((low + high) / 2);
            if (p.apply(array.get(mid)).booleanValue()) {
                high = mid;
                continue;
            }
            low = mid + 1;
        }
        return low;
    }

    public Node findNodeAt(Position position) throws BadLocationException {
        int offset = this.getDocument().offsetAt(position);
        return this.findNodeAt(offset);
    }

    public Node getParent() {
        return this.parent;
    }

    public static enum NodeType {
        DOCUMENT,
        PROPERTY,
        PROPERTY_KEY,
        PROPERTY_VALUE,
        COMMENTS,
        ASSIGN;

    }
}

