/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.microprofile.model;

import com.redhat.microprofile.model.Node;
import com.redhat.microprofile.model.PropertyKey;
import com.redhat.microprofile.model.PropertyValue;

public class Property
extends Node {
    private PropertyKey key;
    private Node delimiterAssign;
    private PropertyValue value;

    public PropertyKey getKey() {
        return this.key;
    }

    void setKey(PropertyKey key) {
        this.key = key;
        key.parent = this;
    }

    public PropertyValue getValue() {
        return this.value;
    }

    void setValue(PropertyValue value) {
        this.value = value;
        value.parent = this;
    }

    public Node getDelimiterAssign() {
        return this.delimiterAssign;
    }

    void setDelimiterAssign(Node delimiterAssign) {
        this.delimiterAssign = delimiterAssign;
        this.delimiterAssign.parent = this;
    }

    public String getPropertyKey() {
        PropertyKey key = this.getKey();
        if (key == null) {
            return null;
        }
        return key.getText();
    }

    public String getProfile() {
        PropertyKey key = this.getKey();
        if (key == null) {
            return null;
        }
        return key.getProfile();
    }

    public String getPropertyName() {
        PropertyKey key = this.getKey();
        if (key == null) {
            return null;
        }
        return key.getPropertyName();
    }

    public String getPropertyNameWithProfile() {
        PropertyKey key = this.getKey();
        if (key == null) {
            return null;
        }
        return key.getPropertyNameWithProfile();
    }

    public String getPropertyValue() {
        PropertyValue value = this.getValue();
        if (value == null) {
            return null;
        }
        return value.getValue();
    }

    @Override
    public Node findNodeAt(int offset) {
        PropertyKey key = this.getKey();
        if (key == null) {
            return this;
        }
        if (key.getEnd() == -1) {
            return key;
        }
        Node assign = this.getDelimiterAssign();
        if (assign == null) {
            return key;
        }
        if (assign.getStart() == offset) {
            return assign;
        }
        if (offset >= assign.getStart()) {
            PropertyValue value = this.getValue();
            return value != null ? value : assign;
        }
        return key;
    }

    @Override
    public Node.NodeType getNodeType() {
        return Node.NodeType.PROPERTY;
    }
}

