/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.microprofile.model;

import com.redhat.microprofile.model.Node;

public class PropertyKey
extends Node {
    @Override
    public Node.NodeType getNodeType() {
        return Node.NodeType.PROPERTY_KEY;
    }

    public String getProfile() {
        int profileEndOffset = this.getEndProfileOffset();
        if (profileEndOffset != -1) {
            String fulltext = this.getOwnerModel().getText();
            return fulltext.substring(this.getStart() + 1, profileEndOffset);
        }
        return null;
    }

    public String getPropertyName() {
        int profileEndOffset = this.getEndProfileOffset();
        if (profileEndOffset != -1) {
            int end = this.getEnd();
            if (profileEndOffset < end) {
                return this.getOwnerModel().getText(profileEndOffset + 1, end, true);
            }
            return null;
        }
        return this.getText(true);
    }

    public String getPropertyNameWithProfile() {
        return this.getText(true);
    }

    public boolean isBeforeProfile(int offset) {
        int profileEndOffset = this.getEndProfileOffset();
        if (profileEndOffset == -1) {
            return false;
        }
        return profileEndOffset >= offset;
    }

    private int getEndProfileOffset() {
        int start = this.getStart();
        int end = this.getEnd();
        if (start == -1 || end == -1) {
            return -1;
        }
        String fulltext = this.getOwnerModel().getText();
        if (start >= fulltext.length()) {
            return -1;
        }
        int i = start;
        if (fulltext.charAt(i) == '%') {
            char c;
            while (i < end && (c = fulltext.charAt(i)) != '.') {
                ++i;
            }
            return i;
        }
        return -1;
    }
}

