/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.microprofile.model.parser;

import com.redhat.microprofile.model.parser.Location;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;

public class ErrorEvent
extends Range {
    private final ErrorType errorType;
    private final String message;

    public ErrorEvent(Location start, Location end, String message, ErrorType errorType) {
        super((Position)start, (Position)end);
        this.message = message;
        this.errorType = errorType;
    }

    public ErrorType getErrorType() {
        return this.errorType;
    }

    public String getMessage() {
        return this.message;
    }

    public static enum ErrorType {
        EXPECTED_END_OF_INPUT(true),
        EXPECTED_STRING_CHARACTER(true),
        GLOB_NOT_CLOSED(true),
        INVALID_GLOB(false),
        INVALID_PROPERTY_VALUE(false),
        PROPERTY_ASSIGNMENT_MISSING(true),
        PROPERTY_VALUE_MISSING(true),
        UNEXPECTED_END_OF_INPUT(true),
        OTHER(false);

        private final boolean syntaxError;

        private ErrorType(boolean syntaxError) {
            this.syntaxError = syntaxError;
        }

        public boolean isSyntaxError() {
            return this.syntaxError;
        }
    }
}

