/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.microprofile.model.parser;

import com.redhat.microprofile.model.parser.ErrorEvent;
import com.redhat.microprofile.model.parser.ErrorHandler;
import com.redhat.microprofile.model.parser.Location;
import com.redhat.microprofile.model.parser.ParseContext;
import com.redhat.microprofile.model.parser.PropertiesHandler;

public class PropertiesParser
implements ParseContext {
    private PropertiesHandler handler;
    private ErrorHandler errorHandler;
    private ParseState parseState;
    private String text;
    private int bufferOffset;
    private int index;
    private int line;
    private int lineOffset;
    private int last;
    private int current;

    public void parse(String text, PropertiesHandler handler, ErrorHandler errorHandler) {
        this.handler = handler;
        this.errorHandler = errorHandler;
        this.parseState = ParseState.Property;
        this.bufferOffset = 0;
        this.index = 0;
        this.line = 1;
        this.lineOffset = 0;
        this.current = 0;
        this.last = -1;
        this.text = text;
        this.readLines();
        if (!this.isEndOfText()) {
            Location location = this.getLocation();
            ErrorEvent e = new ErrorEvent(location, location, "Found unexpected character; expected end of input", ErrorEvent.ErrorType.EXPECTED_END_OF_INPUT);
            errorHandler.error(this, e);
        }
    }

    private void readLines() {
        this.handler.startDocument(this);
        int currentLine = 0;
        do {
            this.read();
            if (currentLine == this.line) continue;
            currentLine = this.line;
            this.readLine();
        } while (!this.isEndOfText());
        if (this.parseState == ParseState.PropertyName) {
            this.handler.endPropertyName(this);
            this.handler.endProperty(this);
        } else if (this.parseState == ParseState.PropertyValue) {
            this.handler.endPropertyValue(this);
            this.handler.endProperty(this);
        }
        this.handler.endDocument(this);
    }

    private void readLine() {
        this.skipWhiteSpace();
        if (this.isNewLine()) {
            this.handler.blankLine(this);
            return;
        }
        if (this.current == 65279) {
            return;
        }
        switch (this.current) {
            case 35: 
            case 59: {
                this.readComment();
                break;
            }
            default: {
                this.readProperty();
            }
        }
    }

    private void readComment() {
        this.handler.startComment(this);
        do {
            this.read();
        } while (!this.isEndOfText() && !this.isNewLine());
        this.handler.endComment(this);
    }

    private void readString(StopReading stop) {
        while (!this.isStopReading(stop)) {
            ErrorEvent e;
            Location location;
            if (this.isEndOfText()) {
                location = this.getLocation();
                e = new ErrorEvent(location, location, "Unexpected end of input", ErrorEvent.ErrorType.UNEXPECTED_END_OF_INPUT);
                this.errorHandler.error(this, e);
                continue;
            }
            if (this.current < 32) {
                location = this.getLocation();
                e = new ErrorEvent(location, location, "Expected a valid string character", ErrorEvent.ErrorType.EXPECTED_STRING_CHARACTER);
                this.errorHandler.error(this, e);
                continue;
            }
            this.read();
        }
    }

    private boolean isStopReading(StopReading stop) {
        if (this.isEndOfText() || this.isNewLine()) {
            return true;
        }
        switch (stop) {
            case PropertyName: {
                return this.isColonSeparator() || this.isWhiteSpace();
            }
            case PropertyValue: {
                return false;
            }
        }
        return this.isWhiteSpace();
    }

    private void readProperty() {
        switch (this.parseState) {
            case PropertyName: {
                if (!this.continueReadPropertyKey()) break;
                this.readAfterPropertyKey();
                break;
            }
            case PropertyValue: {
                if (!this.continueReadPropertyValue()) break;
                this.handler.endProperty(this);
                this.parseState = ParseState.Property;
                break;
            }
            case Property: {
                this.handler.startProperty(this);
                this.skipWhiteSpace();
                if (!this.readPropertyKey()) {
                    this.parseState = ParseState.PropertyName;
                    return;
                }
                this.readAfterPropertyKey();
                break;
            }
            default: {
                return;
            }
        }
    }

    private void readAfterPropertyKey() {
        this.skipWhiteSpace();
        if (this.current != 61 && this.current != 58) {
            this.skipUntilEndOfLine();
            this.handler.endProperty(this);
            this.parseState = ParseState.Property;
            return;
        }
        this.readDelimiter();
        this.skipWhiteSpace();
        if (this.isEndOfText()) {
            this.handler.endProperty(this);
            this.parseState = ParseState.Property;
            return;
        }
        if (this.readPropertyValue()) {
            this.handler.endProperty(this);
            this.parseState = ParseState.Property;
        } else {
            this.parseState = ParseState.PropertyValue;
        }
    }

    private boolean readPropertyKey() {
        this.handler.startPropertyName(this);
        return this.continueReadPropertyKey();
    }

    private boolean readPropertyValue() {
        this.handler.startPropertyValue(this);
        return this.continueReadPropertyValue();
    }

    private boolean continueReadPropertyKey() {
        this.readString(StopReading.PropertyName);
        if (this.last != 92 || PropertiesParser.isWhiteSpace(this.current)) {
            this.handler.endPropertyName(this);
            return true;
        }
        return false;
    }

    private void readDelimiter() {
        this.handler.delimiterAssign(this);
        this.read();
    }

    private boolean continueReadPropertyValue() {
        this.readString(StopReading.PropertyValue);
        if (this.last != 92) {
            this.handler.endPropertyValue(this);
            return true;
        }
        return false;
    }

    private void skipWhiteSpace() {
        while (this.isWhiteSpace()) {
            this.read();
        }
    }

    private void skipUntilEndOfLine() {
        while (!this.isNewLine() && !this.isEndOfText()) {
            this.read();
        }
    }

    private void read() {
        if (this.current == 10) {
            ++this.line;
            this.lineOffset = this.bufferOffset + this.index;
        }
        this.last = this.current;
        int n = this.current = this.index >= this.text.length() ? -1 : (int)this.text.charAt(this.index++);
        if (this.current == -1) {
            ++this.bufferOffset;
        }
    }

    @Override
    public Location getLocation() {
        int offset = this.getLocationOffset();
        int column = offset - this.lineOffset + 1;
        return new Location(offset, this.line, column);
    }

    @Override
    public int getLocationOffset() {
        return this.bufferOffset + this.index - 1;
    }

    private boolean isWhiteSpace() {
        return PropertiesParser.isWhiteSpace(this.current);
    }

    private static boolean isWhiteSpace(int c) {
        return c == 32 || c == 9;
    }

    private boolean isNewLine() {
        return this.current == 10 || this.current == 13;
    }

    private boolean isEndOfText() {
        return this.current == -1;
    }

    private boolean isColonSeparator() {
        return this.current == 61 || this.current == 58;
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    private static enum StopReading {
        PropertyName,
        PropertyValue;

    }

    private static enum ParseState {
        Property,
        PropertyName,
        PropertyValue;

    }
}

