/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.microprofile.model.values;

import com.redhat.microprofile.commons.metadata.ItemMetadata;
import com.redhat.microprofile.model.PropertiesModel;
import java.util.Collection;

public class PropertyMatcher {
    private Collection<String> names;
    private Collection<String> types;

    public Collection<String> getNames() {
        return this.names;
    }

    public void setNames(Collection<String> names) {
        this.names = names;
    }

    public Collection<String> getTypes() {
        return this.types;
    }

    public void setTypes(Collection<String> types) {
        this.types = types;
    }

    public boolean match(ItemMetadata metadata, PropertiesModel model) {
        String propertyName = metadata.getName();
        String propertyType = metadata.getType();
        if (this.names != null && this.types != null) {
            return this.matchName(propertyName) && this.matchType(propertyType);
        }
        if (this.names != null) {
            return this.matchName(propertyName);
        }
        if (this.types != null) {
            return this.matchType(propertyType);
        }
        return false;
    }

    private boolean matchName(String propertyName) {
        return this.names.contains(propertyName);
    }

    private boolean matchType(String propertyType) {
        return this.types.contains(propertyType);
    }
}

