/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.microprofile.model.values;

import com.redhat.microprofile.commons.metadata.ItemHint;
import com.redhat.microprofile.commons.metadata.ItemMetadata;
import com.redhat.microprofile.model.PropertiesModel;
import com.redhat.microprofile.model.values.PropertyMatcher;
import java.util.List;
import java.util.stream.Collectors;

public class ValuesRule {
    private PropertyMatcher matcher;
    private List<ItemHint.ValueHint> values;
    private List<String> valuesRef;
    private transient boolean valuesCleaned;

    public PropertyMatcher getMatcher() {
        return this.matcher;
    }

    public void setMatcher(PropertyMatcher matcher) {
        this.matcher = matcher;
    }

    public void setValues(List<ItemHint.ValueHint> values) {
        this.values = values;
        this.valuesCleaned = false;
    }

    public List<ItemHint.ValueHint> getValues() {
        this.cleanValues();
        return this.values;
    }

    private void cleanValues() {
        if (this.valuesCleaned || this.values == null || this.values.isEmpty()) {
            return;
        }
        try {
            this.values = this.values.stream().filter(e -> e.getValue() != null && !e.getValue().isEmpty()).collect(Collectors.toList());
        }
        finally {
            this.valuesCleaned = true;
        }
    }

    public List<String> getValuesRef() {
        return this.valuesRef;
    }

    public boolean match(ItemMetadata metadata, PropertiesModel model) {
        return this.getMatcher().match(metadata, model);
    }
}

