/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.microprofile.services;

import com.redhat.microprofile.commons.MicroProfileProjectInfo;
import com.redhat.microprofile.commons.metadata.ConverterKind;
import com.redhat.microprofile.commons.metadata.ItemHint;
import com.redhat.microprofile.commons.metadata.ItemMetadata;
import com.redhat.microprofile.ls.commons.BadLocationException;
import com.redhat.microprofile.ls.commons.CodeActionFactory;
import com.redhat.microprofile.ls.commons.TextDocument;
import com.redhat.microprofile.ls.commons.client.ConfigurationItemEdit;
import com.redhat.microprofile.ls.commons.client.ConfigurationItemEditType;
import com.redhat.microprofile.model.PropertiesModel;
import com.redhat.microprofile.model.Property;
import com.redhat.microprofile.model.PropertyKey;
import com.redhat.microprofile.model.PropertyValue;
import com.redhat.microprofile.model.values.ValuesRulesManager;
import com.redhat.microprofile.services.LevenshteinDistance;
import com.redhat.microprofile.services.ValidationType;
import com.redhat.microprofile.settings.MicroProfileCommandCapabilities;
import com.redhat.microprofile.settings.MicroProfileFormattingSettings;
import com.redhat.microprofile.utils.MicroProfilePropertiesUtils;
import com.redhat.microprofile.utils.PositionUtils;
import com.redhat.microprofile.utils.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionContext;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentItem;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

class MicroProfileCodeActions {
    private static final float MAX_DISTANCE_DIFF_RATIO = 0.1f;
    private static final Logger LOGGER = Logger.getLogger(MicroProfileCodeActions.class.getName());

    MicroProfileCodeActions() {
    }

    public List<CodeAction> doCodeActions(CodeActionContext context, Range range, PropertiesModel document, MicroProfileProjectInfo projectInfo, ValuesRulesManager valuesRulesManager, MicroProfileFormattingSettings formattingSettings, MicroProfileCommandCapabilities commandCapabilities) {
        ArrayList<CodeAction> codeActions = new ArrayList<CodeAction>();
        if (context.getDiagnostics() != null) {
            this.doCodeActionForAllRequired(context.getDiagnostics(), document, formattingSettings, codeActions);
            for (Diagnostic diagnostic : context.getDiagnostics()) {
                if (ValidationType.unknown.isValidationType((Either<String, Number>)diagnostic.getCode())) {
                    this.doCodeActionsForUnknown(diagnostic, document, projectInfo, commandCapabilities, codeActions);
                    continue;
                }
                if (!ValidationType.value.isValidationType((Either<String, Number>)diagnostic.getCode())) continue;
                this.doCodeActionsForUnknownEnumValue(diagnostic, document, projectInfo, valuesRulesManager, codeActions);
            }
        }
        return codeActions;
    }

    private void doCodeActionsForUnknown(Diagnostic diagnostic, PropertiesModel document, MicroProfileProjectInfo projectInfo, MicroProfileCommandCapabilities commandCapabilities, List<CodeAction> codeActions) {
        try {
            PropertyKey propertyKey = (PropertyKey)document.findNodeAt(diagnostic.getRange().getStart());
            String propertyName = propertyKey.getPropertyName();
            for (ItemMetadata metaProperty : projectInfo.getProperties()) {
                String name = metaProperty.getName();
                if (MicroProfilePropertiesUtils.isMappedProperty(name) || !MicroProfileCodeActions.isSimilar(metaProperty.getName(), propertyName)) continue;
                Range range = PositionUtils.createRange(propertyKey);
                CodeAction replaceAction = CodeActionFactory.replace("Did you mean '" + name + "' ?", range, name, document.getDocument(), diagnostic);
                codeActions.add(replaceAction);
            }
            if (commandCapabilities.isCommandSupported("quarkus.command.configuration.update")) {
                this.doCodeActionForIgnoreUnknownValidation(propertyName, diagnostic, document, projectInfo, codeActions);
            }
        }
        catch (BadLocationException e) {
            LOGGER.log(Level.SEVERE, "In MicroProfileCodeActions, position error", e);
        }
    }

    private void doCodeActionsForUnknownEnumValue(Diagnostic diagnostic, PropertiesModel document, MicroProfileProjectInfo projectInfo, ValuesRulesManager valuesRulesManager, List<CodeAction> codeActions) {
        try {
            PropertyValue propertyValue = (PropertyValue)document.findNodeAt(diagnostic.getRange().getStart());
            PropertyKey propertyKey = ((Property)propertyValue.getParent()).getKey();
            String value = propertyValue.getValue();
            String propertyName = propertyKey.getPropertyName();
            ItemMetadata metaProperty = MicroProfilePropertiesUtils.getProperty(propertyName, projectInfo);
            if (metaProperty == null) {
                return;
            }
            Collection<ItemHint.ValueHint> enums = MicroProfilePropertiesUtils.getEnums(metaProperty, projectInfo, document, valuesRulesManager);
            if (enums == null || enums.isEmpty()) {
                return;
            }
            List<ConverterKind> converterKinds = metaProperty.getConverterKinds();
            ArrayList<String> similarEnums = new ArrayList<String>();
            for (ItemHint.ValueHint e : enums) {
                if (converterKinds != null && !converterKinds.isEmpty()) {
                    for (ConverterKind converterKind : converterKinds) {
                        String convertedValue = e.getValue(converterKind);
                        if (!MicroProfileCodeActions.isSimilarPropertyValue(convertedValue, value)) continue;
                        similarEnums.add(convertedValue);
                    }
                    continue;
                }
                if (!MicroProfileCodeActions.isSimilarPropertyValue(e.getValue(), value)) continue;
                similarEnums.add(e.getValue());
            }
            Range range = PositionUtils.createRange(propertyValue);
            if (!similarEnums.isEmpty()) {
                for (String similarValue : similarEnums) {
                    CodeAction replaceAction = CodeActionFactory.replace("Did you mean '" + similarValue + "'?", range, similarValue, document.getDocument(), diagnostic);
                    codeActions.add(replaceAction);
                }
            } else {
                for (ItemHint.ValueHint e : enums) {
                    String preferredValue = e.getPreferredValue(converterKinds);
                    CodeAction replaceAction = CodeActionFactory.replace("Replace with '" + preferredValue + "'?", range, preferredValue, document.getDocument(), diagnostic);
                    codeActions.add(replaceAction);
                }
            }
        }
        catch (BadLocationException e) {
            LOGGER.log(Level.SEVERE, "In MicroProfileCodeActions, position error", e);
        }
    }

    private void doCodeActionForIgnoreUnknownValidation(String propertyName, Diagnostic diagnostic, PropertiesModel document, MicroProfileProjectInfo projectInfo, List<CodeAction> codeActions) {
        codeActions.add(this.createAddToExcludedCodeAction(propertyName, diagnostic));
        while (this.hasParentKey(propertyName)) {
            if ((propertyName = this.getParentKey(propertyName)).equals("quarkus")) continue;
            String globPattern = propertyName + ".*";
            codeActions.add(this.createAddToExcludedCodeAction(globPattern, diagnostic));
        }
    }

    private CodeAction createAddToExcludedCodeAction(String item, Diagnostic diagnostic) {
        CodeAction insertCodeAction = new CodeAction("Exclude '" + item + "' from unknown property validation?");
        ConfigurationItemEdit configItemEdit = new ConfigurationItemEdit("quarkus.tools.validation.unknown.excluded", ConfigurationItemEditType.add, item);
        Command command = new Command("Add " + item + " to unknown excluded array", "quarkus.command.configuration.update", Collections.singletonList(configItemEdit));
        insertCodeAction.setCommand(command);
        insertCodeAction.setKind("quickfix");
        insertCodeAction.setDiagnostics(Collections.singletonList(diagnostic));
        return insertCodeAction;
    }

    private void doCodeActionForAllRequired(List<Diagnostic> diagnostics, PropertiesModel document, MicroProfileFormattingSettings formattingSettings, List<CodeAction> codeActions) {
        TextDocument textDocument = document.getDocument();
        List<Diagnostic> requiredDiagnostics = diagnostics.stream().filter(d -> ValidationType.required.isValidationType((Either<String, Number>)d.getCode())).collect(Collectors.toList());
        if (requiredDiagnostics.isEmpty()) {
            return;
        }
        try {
            Position position = this.getPositionForRequiredCodeAction(textDocument);
            String lineDelimiter = document.getDocument().lineDelimiter(0);
            String assign = formattingSettings.isSurroundEqualsWithSpaces() ? " = " : "=";
            StringBuilder stringToInsert = new StringBuilder();
            if (StringUtils.hasText(textDocument.getText())) {
                stringToInsert.append(lineDelimiter);
            }
            for (int i = 0; i < requiredDiagnostics.size(); ++i) {
                Diagnostic diagnostic = (Diagnostic)requiredDiagnostics.get(i);
                stringToInsert.append(this.getPropertyNameFromRequiredMessage(diagnostic.getMessage()));
                stringToInsert.append(assign);
                if (i >= requiredDiagnostics.size() - 1) continue;
                stringToInsert.append(lineDelimiter);
            }
            CodeAction insertAction = CodeActionFactory.insert("Add all missing required properties?", position, stringToInsert.toString(), (TextDocumentItem)textDocument, requiredDiagnostics);
            codeActions.add(insertAction);
        }
        catch (BadLocationException e) {
            LOGGER.log(Level.SEVERE, "In MicroProfileCodeActions, position error", e);
        }
    }

    private boolean hasParentKey(String propertyName) {
        return propertyName.lastIndexOf(46) >= 0;
    }

    private String getParentKey(String propertyName) {
        return propertyName.substring(0, propertyName.lastIndexOf(46));
    }

    private Position getPositionForRequiredCodeAction(TextDocument textDocument) throws BadLocationException {
        String textDocumentText = textDocument.getText();
        if (!StringUtils.hasText(textDocumentText)) {
            return new Position(0, 0);
        }
        for (int i = textDocumentText.length() - 1; i >= 0; --i) {
            if (Character.isWhitespace(textDocumentText.charAt(i))) continue;
            return textDocument.positionAt(i + 1);
        }
        return null;
    }

    private String getPropertyNameFromRequiredMessage(String diagnosticMessage) {
        int start = diagnosticMessage.indexOf(39) + 1;
        int end = diagnosticMessage.indexOf(39, start);
        return diagnosticMessage.substring(start, end);
    }

    private static boolean isSimilarPropertyValue(String reference, String current) {
        return reference.startsWith(current) ? true : MicroProfileCodeActions.isSimilar(reference, current);
    }

    private static boolean isSimilar(String reference, String current) {
        int threshold = Math.round(0.1f * (float)reference.length());
        LevenshteinDistance levenshteinDistance = new LevenshteinDistance(threshold);
        return levenshteinDistance.apply(reference, current) != -1;
    }
}

