/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.microprofile.services;

import com.redhat.microprofile.commons.MicroProfileProjectInfo;
import com.redhat.microprofile.commons.MicroProfilePropertyDefinitionParams;
import com.redhat.microprofile.commons.metadata.ItemHint;
import com.redhat.microprofile.commons.metadata.ItemMetadata;
import com.redhat.microprofile.ls.api.MicroProfilePropertyDefinitionProvider;
import com.redhat.microprofile.ls.commons.BadLocationException;
import com.redhat.microprofile.model.Node;
import com.redhat.microprofile.model.PropertiesModel;
import com.redhat.microprofile.model.Property;
import com.redhat.microprofile.model.PropertyKey;
import com.redhat.microprofile.model.PropertyValue;
import com.redhat.microprofile.utils.MicroProfilePropertiesUtils;
import com.redhat.microprofile.utils.PositionUtils;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.LocationLink;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public class MicroProfileDefinition {
    private static final Logger LOGGER = Logger.getLogger(MicroProfileDefinition.class.getName());

    public CompletableFuture<Either<List<? extends Location>, List<? extends LocationLink>>> findDefinition(PropertiesModel document, Position position, MicroProfileProjectInfo projectInfo, MicroProfilePropertyDefinitionProvider provider, boolean definitionLinkSupport) {
        try {
            Node node = document.findNodeAt(position);
            if (node == null) {
                return CompletableFuture.completedFuture(MicroProfileDefinition.getEmptyDefinition(definitionLinkSupport));
            }
            PropertyKey key = MicroProfileDefinition.getPropertyKey(node);
            if (key == null) {
                return CompletableFuture.completedFuture(MicroProfileDefinition.getEmptyDefinition(definitionLinkSupport));
            }
            ItemMetadata item = MicroProfilePropertiesUtils.getProperty(key.getPropertyName(), projectInfo);
            if (item == null) {
                return CompletableFuture.completedFuture(MicroProfileDefinition.getEmptyDefinition(definitionLinkSupport));
            }
            MicroProfilePropertyDefinitionParams definitionParams = MicroProfileDefinition.getPropertyDefinitionParams(document, item, projectInfo, node);
            if (definitionParams == null) {
                return CompletableFuture.completedFuture(MicroProfileDefinition.getEmptyDefinition(definitionLinkSupport));
            }
            return provider.getPropertyDefinition(definitionParams).thenApply(target -> {
                if (target == null) {
                    return MicroProfileDefinition.getEmptyDefinition(definitionLinkSupport);
                }
                if (definitionLinkSupport) {
                    LocationLink link = new LocationLink(target.getUri(), target.getRange(), target.getRange(), PositionUtils.createRange(node));
                    return Either.forRight(Collections.singletonList(link));
                }
                return Either.forLeft(Collections.singletonList(target));
            });
        }
        catch (BadLocationException e) {
            LOGGER.log(Level.SEVERE, "In MicroProfileDefinition, position error", e);
            return CompletableFuture.completedFuture(MicroProfileDefinition.getEmptyDefinition(definitionLinkSupport));
        }
    }

    private static Either<List<? extends Location>, List<? extends LocationLink>> getEmptyDefinition(boolean definitionLinkSupport) {
        return definitionLinkSupport ? Either.forRight(Collections.emptyList()) : Either.forLeft(Collections.emptyList());
    }

    private static MicroProfilePropertyDefinitionParams getPropertyDefinitionParams(PropertiesModel document, ItemMetadata item, MicroProfileProjectInfo projectInfo, Node node) {
        if (node.getNodeType() != Node.NodeType.PROPERTY_KEY && node.getNodeType() != Node.NodeType.PROPERTY_VALUE) {
            return null;
        }
        MicroProfilePropertyDefinitionParams definitionParams = new MicroProfilePropertyDefinitionParams();
        String sourceType = null;
        String sourceField = null;
        switch (node.getNodeType()) {
            case PROPERTY_KEY: {
                sourceType = item.getSourceType();
                sourceField = item.getSourceField();
                break;
            }
            case PROPERTY_VALUE: {
                ItemHint.ValueHint realValue;
                sourceType = item.getHintType();
                sourceField = ((PropertyValue)node).getValue();
                ItemHint itemHint = projectInfo.getHint(sourceType);
                if (itemHint == null || (realValue = itemHint.getValue(sourceField, item.getConverterKinds())) == null) break;
                sourceField = realValue.getValue();
                break;
            }
            default: {
                return null;
            }
        }
        if (sourceType == null) {
            return null;
        }
        definitionParams.setSourceType(sourceType);
        definitionParams.setSourceField(sourceField);
        definitionParams.setUri(document.getDocumentURI());
        definitionParams.setSourceMethod(item.getSourceMethod());
        return definitionParams;
    }

    private static PropertyKey getPropertyKey(Node node) {
        if (node == null) {
            return null;
        }
        switch (node.getNodeType()) {
            case PROPERTY_KEY: {
                return (PropertyKey)node;
            }
            case PROPERTY_VALUE: {
                return ((Property)node.getParent()).getKey();
            }
        }
        return null;
    }
}

