/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.microprofile.services;

import com.redhat.microprofile.commons.MicroProfileProjectInfo;
import com.redhat.microprofile.commons.metadata.ConfigurationMetadata;
import com.redhat.microprofile.commons.metadata.ItemHint;
import com.redhat.microprofile.commons.metadata.ItemMetadata;
import com.redhat.microprofile.ls.commons.BadLocationException;
import com.redhat.microprofile.model.Node;
import com.redhat.microprofile.model.PropertiesModel;
import com.redhat.microprofile.model.Property;
import com.redhat.microprofile.model.PropertyKey;
import com.redhat.microprofile.model.PropertyValue;
import com.redhat.microprofile.model.values.ValuesRulesManager;
import com.redhat.microprofile.services.QuarkusModel;
import com.redhat.microprofile.settings.MicroProfileHoverSettings;
import com.redhat.microprofile.utils.DocumentationUtils;
import com.redhat.microprofile.utils.MicroProfilePropertiesUtils;
import com.redhat.microprofile.utils.PositionUtils;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.MarkupContent;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;

class MicroProfileHover {
    private static final Logger LOGGER = Logger.getLogger(MicroProfileHover.class.getName());

    MicroProfileHover() {
    }

    public Hover doHover(PropertiesModel document, Position position, MicroProfileProjectInfo projectInfo, ValuesRulesManager valuesRulesManager, MicroProfileHoverSettings hoverSettings) {
        Node node = null;
        int offset = -1;
        try {
            node = document.findNodeAt(position);
            offset = document.offsetAt(position);
        }
        catch (BadLocationException e) {
            LOGGER.log(Level.SEVERE, "MicroProfileHover, position error", e);
            return null;
        }
        if (node == null) {
            return null;
        }
        switch (node.getNodeType()) {
            case COMMENTS: {
                return null;
            }
            case PROPERTY_VALUE: {
                return MicroProfileHover.getPropertyValueHover(node, projectInfo, valuesRulesManager, hoverSettings);
            }
            case PROPERTY_KEY: {
                PropertyKey key = (PropertyKey)node;
                if (key.isBeforeProfile(offset)) {
                    return MicroProfileHover.getProfileHover(key, hoverSettings);
                }
                return MicroProfileHover.getPropertyKeyHover(key, projectInfo, hoverSettings);
            }
        }
        return null;
    }

    private static Hover getProfileHover(PropertyKey key, MicroProfileHoverSettings hoverSettings) {
        boolean markdownSupported = hoverSettings.isContentFormatSupported("markdown");
        for (ItemHint.ValueHint profile : QuarkusModel.DEFAULT_PROFILES.getValues()) {
            if (!profile.getValue().equals(key.getProfile())) continue;
            MarkupContent markupContent = DocumentationUtils.getDocumentation(profile, markdownSupported);
            Hover hover = new Hover();
            hover.setContents(markupContent);
            hover.setRange(MicroProfileHover.getProfileHoverRange(key));
            return hover;
        }
        return null;
    }

    private static Hover getPropertyKeyHover(PropertyKey key, MicroProfileProjectInfo projectInfo, MicroProfileHoverSettings hoverSettings) {
        boolean markdownSupported = hoverSettings.isContentFormatSupported("markdown");
        String propertyName = key.getPropertyName();
        ItemMetadata item = MicroProfilePropertiesUtils.getProperty(propertyName, projectInfo);
        if (item != null) {
            MarkupContent markupContent = DocumentationUtils.getDocumentation(item, key.getProfile(), markdownSupported);
            Hover hover = new Hover();
            hover.setContents(markupContent);
            hover.setRange(PositionUtils.createRange(key));
            return hover;
        }
        return null;
    }

    private static Hover getPropertyValueHover(Node node, MicroProfileProjectInfo projectInfo, ValuesRulesManager valuesRulesManager, MicroProfileHoverSettings hoverSettings) {
        PropertyValue value = (PropertyValue)node;
        boolean markdownSupported = hoverSettings.isContentFormatSupported("markdown");
        String propertyValue = value.getValue();
        if (propertyValue == null || propertyValue.isEmpty()) {
            return null;
        }
        String propertyName = ((Property)value.getParent()).getPropertyName();
        ItemMetadata item = MicroProfilePropertiesUtils.getProperty(propertyName, projectInfo);
        ItemHint.ValueHint enumItem = MicroProfileHover.getValueHint(propertyValue, item, projectInfo, valuesRulesManager, value.getOwnerModel());
        if (enumItem != null) {
            MarkupContent markupContent = DocumentationUtils.getDocumentation(enumItem, markdownSupported);
            Hover hover = new Hover();
            hover.setContents(markupContent);
            hover.setRange(PositionUtils.createRange(node));
            return hover;
        }
        return null;
    }

    private static Range getProfileHoverRange(PropertyKey key) {
        Range range = PositionUtils.createRange(key);
        if (key.getProfile() == null) {
            return range;
        }
        String profile = key.getProfile();
        Position endPosition = range.getEnd();
        endPosition.setCharacter(range.getStart().getCharacter() + profile.length() + 1);
        range.setEnd(endPosition);
        return range;
    }

    private static ItemHint.ValueHint getValueHint(String propertyValue, ItemMetadata metadata, ConfigurationMetadata configuration, ValuesRulesManager valuesRulesManager, PropertiesModel model) {
        ItemHint.ValueHint valueHint;
        if (metadata == null) {
            return null;
        }
        ItemHint enumItem = configuration.getHint(metadata);
        if (enumItem != null && (valueHint = enumItem.getValue(propertyValue, metadata.getConverterKinds())) != null) {
            return valueHint;
        }
        return valuesRulesManager.getValueHint(propertyValue, metadata, model);
    }
}

