/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.microprofile.services;

import com.redhat.microprofile.model.Node;
import com.redhat.microprofile.model.PropertiesModel;
import com.redhat.microprofile.model.Property;
import com.redhat.microprofile.model.PropertyKey;
import com.redhat.microprofile.utils.PositionUtils;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.lsp4j.DocumentSymbol;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.SymbolKind;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;

class MicroProfileSymbolsProvider {
    MicroProfileSymbolsProvider() {
    }

    public List<SymbolInformation> findSymbolInformations(PropertiesModel document, CancelChecker cancelChecker) {
        ArrayList<SymbolInformation> symbols = new ArrayList<SymbolInformation>();
        for (Node node : document.getChildren()) {
            Property property;
            String name;
            if (cancelChecker != null) {
                cancelChecker.checkCanceled();
            }
            if (node.getNodeType() != Node.NodeType.PROPERTY || (name = MicroProfileSymbolsProvider.getSymbolName(property = (Property)node)) == null || name.isEmpty()) continue;
            Range range = MicroProfileSymbolsProvider.getSymbolRange(property);
            Location location = new Location(document.getDocumentURI(), range);
            SymbolInformation symbol = new SymbolInformation(name, MicroProfileSymbolsProvider.getSymbolKind(property), location);
            symbols.add(symbol);
        }
        return symbols;
    }

    public List<DocumentSymbol> findDocumentSymbols(PropertiesModel document, CancelChecker cancelChecker) {
        ArrayList<DocumentSymbol> symbols = new ArrayList<DocumentSymbol>();
        for (Node node : document.getChildren()) {
            Property property;
            String name;
            if (cancelChecker != null) {
                cancelChecker.checkCanceled();
            }
            if (node.getNodeType() != Node.NodeType.PROPERTY || (name = MicroProfileSymbolsProvider.getSymbolName(property = (Property)node)) == null || name.isEmpty()) continue;
            String[] paths = name.split("[.]");
            DocumentSymbol symbol = null;
            for (String path : paths) {
                symbol = MicroProfileSymbolsProvider.getSymbol(path, property, symbol != null ? symbol.getChildren() : symbols);
            }
            symbol.setKind(SymbolKind.Property);
            String value = property.getPropertyValue();
            if (value == null) continue;
            symbol.setDetail(value);
        }
        return symbols;
    }

    private static DocumentSymbol getSymbol(String path, Property property, List<DocumentSymbol> children) {
        for (DocumentSymbol child : children) {
            if (!path.equals(child.getName())) continue;
            return child;
        }
        Range range = MicroProfileSymbolsProvider.getSymbolRange(property);
        DocumentSymbol symbol = new DocumentSymbol(path, SymbolKind.Package, range, range);
        symbol.setChildren(new ArrayList());
        children.add(symbol);
        return symbol;
    }

    private static String getSymbolName(Property property) {
        PropertyKey key = property.getKey();
        if (key == null) {
            return null;
        }
        return key.getPropertyNameWithProfile();
    }

    private static Range getSymbolRange(Property property) {
        return PositionUtils.createRange(property);
    }

    private static SymbolKind getSymbolKind(Property property) {
        return SymbolKind.Property;
    }
}

