/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.microprofile.settings;

import com.redhat.microprofile.utils.AntPathMatcher;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.lsp4j.DiagnosticSeverity;

public class MicroProfileValidationTypeSettings {
    private String severity;
    private String[] excluded;
    private transient List<ExcludedProperty> excludedProperties;

    public String getSeverity() {
        return this.severity;
    }

    public void setSeverity(String severity) {
        this.severity = severity;
    }

    public String[] getExcluded() {
        return this.excluded;
    }

    public void setExcluded(String[] excluded) {
        this.excluded = excluded;
    }

    public DiagnosticSeverity getDiagnosticSeverity(String propertyName) {
        DiagnosticSeverity severity = this.getDiagnosticSeverity();
        if (severity == null) {
            return null;
        }
        return this.isExcluded(propertyName) ? null : severity;
    }

    private DiagnosticSeverity getDiagnosticSeverity() {
        DiagnosticSeverity[] severities;
        for (DiagnosticSeverity severity : severities = DiagnosticSeverity.values()) {
            if (!severity.name().toUpperCase().equals(this.severity.toUpperCase())) continue;
            return severity;
        }
        return null;
    }

    private boolean isExcluded(String propertyName) {
        if (this.excluded == null) {
            return false;
        }
        List<ExcludedProperty> excludedProperties = this.getExcludedProperties();
        for (ExcludedProperty excluded : excludedProperties) {
            if (!excluded.match(propertyName)) continue;
            return true;
        }
        return false;
    }

    private List<ExcludedProperty> getExcludedProperties() {
        if (this.excludedProperties != null) {
            return this.excludedProperties;
        }
        return this.createExcludedProperties();
    }

    private synchronized List<ExcludedProperty> createExcludedProperties() {
        if (this.excludedProperties != null) {
            return this.excludedProperties;
        }
        AntPathMatcher matcher = new AntPathMatcher();
        matcher.setCachePatterns(true);
        return Stream.of(this.excluded).map(p -> new ExcludedProperty((String)p, matcher)).collect(Collectors.toList());
    }

    private static class ExcludedProperty {
        private final String pattern;
        private final AntPathMatcher matcher;

        public ExcludedProperty(String pattern, AntPathMatcher matcher) {
            this.pattern = pattern;
            this.matcher = matcher.isPattern(pattern) ? matcher : null;
        }

        public boolean match(String propertyName) {
            if (this.matcher != null) {
                return this.matcher.match(this.pattern, propertyName);
            }
            return this.pattern.equals(propertyName);
        }
    }
}

