/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.microprofile.settings.capabilities;

import com.redhat.microprofile.ls.commons.client.ExtendedClientCapabilities;
import org.eclipse.lsp4j.ClientCapabilities;
import org.eclipse.lsp4j.DynamicRegistrationCapabilities;
import org.eclipse.lsp4j.TextDocumentClientCapabilities;

public class ClientCapabilitiesWrapper {
    private boolean v3Supported;
    private ClientCapabilities capabilities;
    private final ExtendedClientCapabilities extendedCapabilities;

    public ClientCapabilitiesWrapper() {
        this(new ClientCapabilities(), null);
    }

    public ClientCapabilitiesWrapper(ClientCapabilities capabilities, ExtendedClientCapabilities extendedCapabilities) {
        this.capabilities = capabilities;
        this.v3Supported = capabilities != null ? capabilities.getTextDocument() != null : false;
        this.extendedCapabilities = extendedCapabilities;
    }

    public boolean isCodeActionDynamicRegistered() {
        return this.v3Supported && this.isDynamicRegistrationSupported((DynamicRegistrationCapabilities)this.getTextDocument().getCodeAction());
    }

    public boolean isCodeLensDynamicRegistered() {
        return this.v3Supported && this.isDynamicRegistrationSupported((DynamicRegistrationCapabilities)this.getTextDocument().getCodeLens());
    }

    public boolean isCompletionDynamicRegistrationSupported() {
        return this.v3Supported && this.isDynamicRegistrationSupported((DynamicRegistrationCapabilities)this.getTextDocument().getCompletion());
    }

    public boolean isHoverDynamicRegistered() {
        return this.v3Supported && this.isDynamicRegistrationSupported((DynamicRegistrationCapabilities)this.getTextDocument().getHover());
    }

    public boolean isDocumentSymbolDynamicRegistrationSupported() {
        return this.v3Supported && this.isDynamicRegistrationSupported((DynamicRegistrationCapabilities)this.getTextDocument().getDocumentSymbol());
    }

    public boolean isDefinitionDynamicRegistered() {
        return this.v3Supported && this.isDynamicRegistrationSupported((DynamicRegistrationCapabilities)this.getTextDocument().getDefinition());
    }

    public boolean isFormattingDynamicRegistered() {
        return this.v3Supported && this.isDynamicRegistrationSupported((DynamicRegistrationCapabilities)this.getTextDocument().getFormatting());
    }

    public boolean isRangeFormattingDynamicRegistered() {
        return this.v3Supported && this.isDynamicRegistrationSupported((DynamicRegistrationCapabilities)this.getTextDocument().getRangeFormatting());
    }

    private boolean isDynamicRegistrationSupported(DynamicRegistrationCapabilities capability) {
        return capability != null && capability.getDynamicRegistration() != null && capability.getDynamicRegistration() != false;
    }

    public TextDocumentClientCapabilities getTextDocument() {
        return this.capabilities.getTextDocument();
    }

    public ExtendedClientCapabilities getExtendedCapabilities() {
        return this.extendedCapabilities;
    }

    public boolean isResourceOperationSupported() {
        return this.capabilities.getWorkspace() != null && this.capabilities.getWorkspace().getWorkspaceEdit() != null && this.capabilities.getWorkspace().getWorkspaceEdit().getResourceOperations() != null && this.capabilities.getWorkspace().getWorkspaceEdit().getResourceOperations().contains("create") && this.capabilities.getWorkspace().getWorkspaceEdit().getResourceOperations().contains("rename") && this.capabilities.getWorkspace().getWorkspaceEdit().getResourceOperations().contains("delete");
    }
}

