/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.microprofile.settings.capabilities;

import com.redhat.microprofile.settings.capabilities.ClientCapabilitiesWrapper;
import com.redhat.microprofile.settings.capabilities.ServerCapabilitiesConstants;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.TextDocumentSyncKind;

public class ServerCapabilitiesInitializer {
    private ServerCapabilitiesInitializer() {
    }

    public static ServerCapabilities getNonDynamicServerCapabilities(ClientCapabilitiesWrapper clientCapabilities) {
        ServerCapabilities serverCapabilities = new ServerCapabilities();
        serverCapabilities.setTextDocumentSync(TextDocumentSyncKind.Incremental);
        serverCapabilities.setHoverProvider(Boolean.valueOf(!clientCapabilities.isHoverDynamicRegistered()));
        serverCapabilities.setDocumentFormattingProvider(Boolean.valueOf(!clientCapabilities.isFormattingDynamicRegistered()));
        serverCapabilities.setDocumentRangeFormattingProvider(Boolean.valueOf(!clientCapabilities.isRangeFormattingDynamicRegistered()));
        if (!clientCapabilities.isCompletionDynamicRegistrationSupported()) {
            serverCapabilities.setCompletionProvider(ServerCapabilitiesConstants.DEFAULT_COMPLETION_OPTIONS);
        }
        serverCapabilities.setDocumentSymbolProvider(Boolean.valueOf(!clientCapabilities.isDocumentSymbolDynamicRegistrationSupported()));
        serverCapabilities.setDefinitionProvider(Boolean.valueOf(!clientCapabilities.isDefinitionDynamicRegistered()));
        if (!clientCapabilities.isCodeLensDynamicRegistered()) {
            serverCapabilities.setCodeLensProvider(ServerCapabilitiesConstants.DEFAULT_CODELENS_OPTIONS);
        }
        return serverCapabilities;
    }
}

