/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.microprofile.snippets;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.redhat.microprofile.commons.ProjectLabelInfoEntry;
import com.redhat.microprofile.ls.commons.snippets.ISnippetContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class SnippetContextForJava
implements ISnippetContext<ProjectLabelInfoEntry> {
    public static final TypeAdapter<SnippetContextForJava> TYPE_ADAPTER = new SnippetContextForJavaAdapter();
    private List<String> types;

    public SnippetContextForJava(List<String> types) {
        this.types = types;
    }

    public List<String> getTypes() {
        return this.types;
    }

    @Override
    public boolean isMatch(ProjectLabelInfoEntry context) {
        if (context == null) {
            return true;
        }
        if (this.types == null || this.types.isEmpty()) {
            return true;
        }
        for (String type : this.types) {
            if (!context.hasLabel(type)) continue;
            return true;
        }
        return false;
    }

    private static class SnippetContextForJavaAdapter
    extends TypeAdapter<SnippetContextForJava> {
        private SnippetContextForJavaAdapter() {
        }

        public SnippetContextForJava read(JsonReader in) throws IOException {
            JsonToken nextToken = in.peek();
            if (nextToken == JsonToken.NULL) {
                return null;
            }
            ArrayList<String> types = new ArrayList<String>();
            in.beginObject();
            block6: while (in.hasNext()) {
                String name;
                switch (name = in.nextName()) {
                    case "type": {
                        if (in.peek() == JsonToken.BEGIN_ARRAY) {
                            in.beginArray();
                            while (in.peek() != JsonToken.END_ARRAY) {
                                types.add(in.nextString());
                            }
                            in.endArray();
                            continue block6;
                        }
                        types.add(in.nextString());
                        continue block6;
                    }
                }
                in.skipValue();
            }
            in.endObject();
            return new SnippetContextForJava(types);
        }

        public void write(JsonWriter out, SnippetContextForJava value) throws IOException {
        }
    }
}

