/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.microprofile.utils;

import com.redhat.microprofile.commons.metadata.ItemHint;
import com.redhat.microprofile.commons.metadata.ItemMetadata;
import com.redhat.microprofile.utils.MicroProfilePropertiesUtils;
import org.eclipse.lsp4j.MarkupContent;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public class DocumentationUtils {
    private DocumentationUtils() {
    }

    public static MarkupContent getDocumentation(ItemMetadata item, String profile, boolean markdown) {
        StringBuilder documentation = new StringBuilder();
        if (markdown) {
            documentation.append("**");
        }
        documentation.append(markdown ? MicroProfilePropertiesUtils.formatPropertyForMarkdown(item.getName()) : item.getName());
        if (markdown) {
            documentation.append("**");
        }
        documentation.append(System.lineSeparator());
        String description = item.getDescription();
        if (description != null) {
            documentation.append(System.lineSeparator());
            documentation.append(description);
            documentation.append(System.lineSeparator());
        }
        DocumentationUtils.addParameter("Profile", profile, documentation, markdown);
        DocumentationUtils.addParameter("Type", item.getType(), documentation, markdown);
        DocumentationUtils.addParameter("Default", item.getDefaultValue(), documentation, markdown);
        DocumentationUtils.addParameter("Phase", DocumentationUtils.getPhaseLabel(item.getPhase()), documentation, markdown);
        DocumentationUtils.addParameter("Extension", item.getExtensionName(), documentation, markdown);
        return new MarkupContent(markdown ? "markdown" : "plaintext", documentation.toString());
    }

    private static String getPhaseLabel(int phase) {
        switch (phase) {
            case 1: {
                return "buildtime";
            }
            case 4: {
                return "runtime";
            }
            case 2: {
                return "buildtime & runtime";
            }
            case 3: {
                return "bootstrap";
            }
        }
        return null;
    }

    private static void addParameter(String name, String value, StringBuilder documentation, boolean markdown) {
        if (value != null) {
            documentation.append(System.lineSeparator());
            if (markdown) {
                documentation.append(" * ");
            }
            documentation.append(name);
            documentation.append(": ");
            if (markdown) {
                documentation.append("`");
            }
            documentation.append(value);
            if (markdown) {
                documentation.append("`");
            }
        }
    }

    public static MarkupContent getDocumentation(ItemHint.ValueHint item, boolean markdown) {
        StringBuilder documentation = new StringBuilder();
        if (markdown) {
            documentation.append("**");
        }
        documentation.append(markdown ? MicroProfilePropertiesUtils.formatPropertyForMarkdown(item.getValue()) : item.getValue());
        if (markdown) {
            documentation.append("**");
        }
        documentation.append(System.lineSeparator());
        String javaDoc = item.getDescription();
        if (javaDoc != null) {
            documentation.append(System.lineSeparator());
            documentation.append(javaDoc);
            documentation.append(System.lineSeparator());
        }
        return new MarkupContent(markdown ? "markdown" : "plaintext", documentation.toString());
    }

    public static String getDocumentationTextFromEither(Either<String, MarkupContent> documentation) {
        if (documentation == null) {
            return null;
        }
        if (documentation.isRight()) {
            return ((MarkupContent)documentation.getRight()).getValue();
        }
        return (String)documentation.getLeft();
    }
}

