/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.microprofile.utils;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.redhat.microprofile.commons.MicroProfileProjectInfo;
import com.redhat.microprofile.commons.metadata.ConfigurationMetadata;
import com.redhat.microprofile.commons.metadata.ItemHint;
import com.redhat.microprofile.commons.metadata.ItemMetadata;
import java.util.List;

public class JSONSchemaUtils {
    private static final String TILDE_PROP = "~";
    private static final String SCHEMA_PROP = "$schema";
    private static final String SCHEMA_URL = "http://json-schema.org/draft-07/schema#";
    private static final String ROOT_PROP = "root";
    private static final String DEFINITIONS_PROP = "definitions";
    private static final String PROFILE_PATTERN = "^[%][a-zA-Z0-9]*$";
    private static final String DEFINITIONS_ROOT = "#/definitions/root";
    private static final String PATTERN_PROPERTIES_PROP = "patternProperties";
    private static final String $REF_PROP = "$ref";
    private static final String DESCRIPTION_PROP = "description";
    private static final String PROPERTIES_PROP = "properties";
    private static final String ADDITIONAL_PROPERTIES_PROP = "additionalProperties";
    private static final String TYPE_PROP = "type";
    private static final String ENUM_PROP = "enum";
    private static final String ITEMS_PROP = "items";

    public static String toJSONSchema(MicroProfileProjectInfo info, boolean lenient) {
        JsonObject schema = new JsonObject();
        schema.addProperty(SCHEMA_PROP, SCHEMA_URL);
        JSONSchemaUtils.generateDefinitions(info, schema, lenient);
        schema.addProperty($REF_PROP, DEFINITIONS_ROOT);
        JSONSchemaUtils.generateProfile(schema);
        return new Gson().toJson((JsonElement)schema);
    }

    private static void generateDefinitions(MicroProfileProjectInfo info, JsonObject schema, boolean lenient) {
        JsonObject definitions = new JsonObject();
        schema.add(DEFINITIONS_PROP, (JsonElement)definitions);
        JsonObject root = new JsonObject();
        definitions.add(ROOT_PROP, (JsonElement)root);
        root.addProperty(TYPE_PROP, JSONSchemaType.object.getName());
        if (!lenient) {
            root.addProperty(ADDITIONAL_PROPERTIES_PROP, Boolean.valueOf(false));
        }
        JsonObject properties = new JsonObject();
        root.add(PROPERTIES_PROP, (JsonElement)properties);
        List<ItemMetadata> items = info.getProperties();
        if (items != null && !items.isEmpty()) {
            items.forEach(item -> JSONSchemaUtils.generateProperty(info, item, properties, lenient));
        }
    }

    private static void generateProperty(ConfigurationMetadata configuration, ItemMetadata item, JsonObject properties, boolean lenient) {
        JsonObject parent = properties;
        String[] paths = item.getPaths();
        if (paths == null) {
            return;
        }
        for (int i = 0; i < paths.length - 1; ++i) {
            String path = paths[i];
            boolean isArray = false;
            if (path.endsWith("[*]")) {
                path = path.substring(0, path.length() - 3);
                isArray = true;
            }
            parent = JSONSchemaUtils.getParentProperties(parent, path, isArray, lenient);
        }
        JSONSchemaUtils.addProperty(paths[paths.length - 1], configuration, item, parent, lenient);
    }

    private static JsonObject getParentProperties(JsonObject parent, String path, boolean isArray, boolean lenient) {
        if (!parent.has(path)) {
            JsonObject object = JSONSchemaUtils.addProperty(path, isArray ? JSONSchemaType.array : JSONSchemaType.object, null, null, parent, lenient);
            return JSONSchemaUtils.getOrCreateProperties(object, isArray);
        }
        JsonObject object = parent.getAsJsonObject(path);
        if (!isArray && object.has(TYPE_PROP) && !JSONSchemaType.object.getName().equals(object.get(TYPE_PROP).getAsString())) {
            parent.remove(path);
            JsonObject newObject = JSONSchemaUtils.addProperty(path, JSONSchemaType.object, null, null, parent, lenient);
            JsonObject properties = new JsonObject();
            newObject.add(PROPERTIES_PROP, (JsonElement)properties);
            properties.add(TILDE_PROP, (JsonElement)object);
            return properties;
        }
        return JSONSchemaUtils.getOrCreateProperties(object, isArray);
    }

    private static JsonObject getOrCreateProperties(JsonObject parent, boolean isArray) {
        if (isArray) {
            JsonObject items = null;
            if (parent.has(ITEMS_PROP)) {
                items = parent.getAsJsonObject(ITEMS_PROP);
            } else {
                items = new JsonObject();
                parent.add(ITEMS_PROP, (JsonElement)items);
                items.addProperty(TYPE_PROP, JSONSchemaType.object.getName());
            }
            return JSONSchemaUtils.getOrCreateProperties(items, false);
        }
        if (parent.has(PROPERTIES_PROP)) {
            return parent.getAsJsonObject(PROPERTIES_PROP);
        }
        JsonObject properties = new JsonObject();
        parent.add(PROPERTIES_PROP, (JsonElement)properties);
        return properties;
    }

    private static void generateProfile(JsonObject schema) {
        JsonObject patternProperties = new JsonObject();
        JsonObject profile = new JsonObject();
        profile.addProperty(TYPE_PROP, JSONSchemaType.object.getName());
        profile.addProperty($REF_PROP, DEFINITIONS_ROOT);
        patternProperties.add(PROFILE_PATTERN, (JsonElement)profile);
        schema.add(PATTERN_PROPERTIES_PROP, (JsonElement)patternProperties);
    }

    private static JsonObject addProperty(String name, ConfigurationMetadata configuration, ItemMetadata item, JsonObject parent, boolean lenient) {
        List<ItemHint.ValueHint> values = JSONSchemaUtils.getValues(configuration, item);
        JSONSchemaType type = JSONSchemaUtils.getType(item, values);
        JsonObject property = JSONSchemaUtils.addProperty(name, type, item.getDescription(), item.getDefaultValue(), parent, lenient);
        if (values != null) {
            JsonArray enumType = new JsonArray();
            property.add(ENUM_PROP, (JsonElement)enumType);
            for (ItemHint.ValueHint value : values) {
                if (value.getValue() == null || value.getValue().isEmpty()) continue;
                enumType.add(value.getValue());
            }
        }
        return property;
    }

    private static List<ItemHint.ValueHint> getValues(ConfigurationMetadata configuration, ItemMetadata item) {
        List<ItemHint.ValueHint> values;
        ItemHint hint = configuration.getHint(item);
        if (hint != null && (values = hint.getValues()) != null && !values.isEmpty()) {
            return values;
        }
        return null;
    }

    private static JSONSchemaType getType(ItemMetadata item, List<ItemHint.ValueHint> values) {
        if (item.isStringType()) {
            return JSONSchemaType.string;
        }
        if (item.isBooleanType()) {
            return JSONSchemaType.booleanType;
        }
        if (item.isIntegerType() || item.isBigIntegerType()) {
            return JSONSchemaType.integer;
        }
        if (item.isLongType() || item.isShortType() || item.isDoubleType() || item.isFloatType() || item.isBigDecimalType()) {
            return JSONSchemaType.number;
        }
        return values != null ? JSONSchemaType.string : null;
    }

    private static JsonObject addProperty(String name, JSONSchemaType type, String description, String defaultValue, JsonObject parent, boolean lenient) {
        JsonObject property = null;
        if (name.endsWith("[*]")) {
            name = name.substring(0, name.length() - 3);
            JsonObject array = new JsonObject();
            array.addProperty(TYPE_PROP, JSONSchemaType.array.getName());
            parent.add(name, (JsonElement)array);
            JsonObject items = null;
            if (parent.has(ITEMS_PROP)) {
                items = array.getAsJsonObject(ITEMS_PROP);
            } else {
                items = new JsonObject();
                array.add(ITEMS_PROP, (JsonElement)items);
                items.addProperty(TYPE_PROP, JSONSchemaType.object.getName());
            }
            property = items;
        } else {
            property = new JsonObject();
            parent.add(name, (JsonElement)property);
        }
        if (type != null) {
            property.addProperty(TYPE_PROP, type.getName());
            if (JSONSchemaType.object.equals((Object)type) && !lenient) {
                property.addProperty(ADDITIONAL_PROPERTIES_PROP, Boolean.valueOf(false));
            }
        }
        if (description != null) {
            property.addProperty(DESCRIPTION_PROP, description);
        }
        if (defaultValue == null || !defaultValue.isEmpty()) {
            // empty if block
        }
        return property;
    }

    private static enum JSONSchemaType {
        string,
        integer,
        number,
        object,
        array,
        booleanType("boolean"),
        nullType("null");

        private final String name;

        private JSONSchemaType() {
            this(null);
        }

        private JSONSchemaType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name != null ? this.name : this.name();
        }
    }
}

