/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.microprofile.utils;

import com.redhat.microprofile.commons.MicroProfileProjectInfo;
import com.redhat.microprofile.commons.metadata.ConfigurationMetadata;
import com.redhat.microprofile.commons.metadata.ItemHint;
import com.redhat.microprofile.commons.metadata.ItemMetadata;
import com.redhat.microprofile.ls.commons.SnippetsBuilder;
import com.redhat.microprofile.model.PropertiesModel;
import com.redhat.microprofile.model.values.ValuesRulesManager;
import com.redhat.microprofile.services.QuarkusModel;
import java.util.Collection;
import java.util.List;
import java.util.function.BiConsumer;

public class MicroProfilePropertiesUtils {
    private static final BiConsumer<Integer, StringBuilder> KEY_MAP_MARKDOWN_REPLACE = (i, newName) -> newName.append("\\{\\*\\}");
    private static final BiConsumer<Integer, StringBuilder> INDEX_ARRAY_MARKDOWN_REPLACE = (i, newName) -> newName.append("[\\*\\]");
    private static final BiConsumer<Integer, StringBuilder> KEY_MAP_COMPLETION_PLACEHOLDER_REPLACE = (i, newName) -> {
        Integer n = i;
        Integer n2 = i = Integer.valueOf(i + 1);
        SnippetsBuilder.placeholders(n, "key", newName);
    };
    private static final BiConsumer<Integer, StringBuilder> INDEX_ARRAY_COMPLETION_PLACEHOLDER_REPLACE = (i, newName) -> {
        newName.append('[');
        Integer n = i;
        Integer n2 = i = Integer.valueOf(i + 1);
        SnippetsBuilder.placeholders(n, "0", newName);
        newName.append(']');
    };

    public static Collection<ItemHint.ValueHint> getEnums(ItemMetadata property, ConfigurationMetadata configuration, PropertiesModel model, ValuesRulesManager valuesRulesManager) {
        ItemHint hint = configuration.getHint(property);
        if (hint != null) {
            return hint.getValues();
        }
        if (property.isBooleanType()) {
            return QuarkusModel.BOOLEAN_ENUMS.getValues();
        }
        if (valuesRulesManager != null) {
            return valuesRulesManager.getValues(property, model);
        }
        return null;
    }

    public static ItemMetadata getProperty(String propertyName, MicroProfileProjectInfo info) {
        List<ItemMetadata> properties = info.getProperties();
        if (propertyName == null || propertyName.isEmpty()) {
            return null;
        }
        for (ItemMetadata property : properties) {
            if (property == null || !MicroProfilePropertiesUtils.match(propertyName, property.getName())) continue;
            return property;
        }
        return null;
    }

    private static boolean match(String propertyName, String pattern) {
        int i2 = 0;
        int len = Math.max(propertyName.length(), pattern.length());
        for (int i1 = 0; i1 < len; ++i1) {
            char c1 = MicroProfilePropertiesUtils.getCharAt(pattern, i1);
            boolean keyMapOrArrayIndex = false;
            if ('{' == c1 && '*' == MicroProfilePropertiesUtils.getCharAt(pattern, i1 + 1) && '}' == MicroProfilePropertiesUtils.getCharAt(pattern, i1 + 2)) {
                i1 += 2;
                keyMapOrArrayIndex = true;
            } else if ('[' == c1 && '*' == MicroProfilePropertiesUtils.getCharAt(pattern, i1 + 1) && ']' == MicroProfilePropertiesUtils.getCharAt(pattern, i1 + 2)) {
                i1 += 2;
                keyMapOrArrayIndex = true;
            }
            char c2 = MicroProfilePropertiesUtils.getCharAt(propertyName, i2);
            if (keyMapOrArrayIndex) {
                boolean endsWithQuote;
                if (c2 == '\u0000') {
                    return false;
                }
                boolean bl = endsWithQuote = c2 == '\"';
                while (c2 != '\u0000') {
                    c2 = MicroProfilePropertiesUtils.getCharAt(propertyName, ++i2);
                    if (endsWithQuote) {
                        if (c2 != '\"') continue;
                        ++i2;
                        break;
                    }
                    if ('.' != c2 || propertyName.charAt(i2 - 1) == '\\' || propertyName.charAt(i2 - 2) == '\\') continue;
                }
                keyMapOrArrayIndex = false;
                continue;
            }
            if (c2 != c1) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    private static char getCharAt(String text, int index) {
        if (index >= text.length()) {
            return '\u0000';
        }
        return text.charAt(index);
    }

    public static String formatPropertyForMarkdown(String propertyName) {
        return MicroProfilePropertiesUtils.formatProperty(propertyName, KEY_MAP_MARKDOWN_REPLACE, INDEX_ARRAY_MARKDOWN_REPLACE).getPropertyName();
    }

    public static FormattedPropertyResult formatPropertyForCompletion(String propertyName) {
        return MicroProfilePropertiesUtils.formatProperty(propertyName, KEY_MAP_COMPLETION_PLACEHOLDER_REPLACE, INDEX_ARRAY_COMPLETION_PLACEHOLDER_REPLACE);
    }

    private static FormattedPropertyResult formatProperty(String propertyName, BiConsumer<Integer, StringBuilder> keyMapReplace, BiConsumer<Integer, StringBuilder> indexArrayReplace) {
        if (!MicroProfilePropertiesUtils.isMappedProperty(propertyName) && !MicroProfilePropertiesUtils.isIndexArrayProperty(propertyName)) {
            return new FormattedPropertyResult(propertyName, 0);
        }
        StringBuilder newName = new StringBuilder();
        int parameterCount = 0;
        for (int i = 0; i < propertyName.length(); ++i) {
            char c = propertyName.charAt(i);
            if (c == '{') {
                i += 2;
                keyMapReplace.accept(++parameterCount, newName);
                continue;
            }
            if (c == '[') {
                i += 2;
                indexArrayReplace.accept(++parameterCount, newName);
                continue;
            }
            newName.append(c);
        }
        return new FormattedPropertyResult(newName.toString(), parameterCount);
    }

    public static boolean isMappedProperty(String propertyName) {
        return propertyName.indexOf("{*}") != -1;
    }

    public static boolean isIndexArrayProperty(String propertyName) {
        return propertyName.indexOf("[*]") != -1;
    }

    public static class FormattedPropertyResult {
        private final String propertyName;
        private final int parameterCount;

        public FormattedPropertyResult(String propertyName, int parameterCount) {
            this.propertyName = propertyName;
            this.parameterCount = parameterCount;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public int getParameterCount() {
            return this.parameterCount;
        }
    }
}

