/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.enhance.plugins;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javax.persistence.Entity;
import javax.persistence.Transient;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.hibernate.bytecode.enhance.spi.EnhancementContext;
import org.hibernate.bytecode.enhance.spi.Enhancer;

@Mojo(name="enhance")
public class MavenEnhancePlugin
extends AbstractMojo {
    private List<File> classes = new ArrayList<File>();
    private ClassPool pool = new ClassPool(false);
    private static final String CLASS_EXTENSION = ".class";
    @Parameter(property="dir", defaultValue="${project.build.outputDirectory}")
    private String dir = null;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)"Started enhance plugin.....");
        File root = new File(this.dir);
        this.walkDir(root);
        Enhancer enhancer = new Enhancer(new EnhancementContext(){
            private ClassLoader overridden;

            public ClassLoader getLoadingClassLoader() {
                if (null == this.overridden) {
                    return this.getClass().getClassLoader();
                }
                return this.overridden;
            }

            public void setClassLoader(ClassLoader loader) {
                this.overridden = loader;
            }

            public boolean isEntityClass(CtClass classDescriptor) {
                return true;
            }

            public boolean hasLazyLoadableAttributes(CtClass classDescriptor) {
                return true;
            }

            public boolean isLazyLoadable(CtField field) {
                return true;
            }

            public boolean isCompositeClass(CtClass classDescriptor) {
                return false;
            }

            public boolean doDirtyCheckingInline(CtClass classDescriptor) {
                return false;
            }

            public CtField[] order(CtField[] fields) {
                return fields;
            }

            public boolean isPersistentField(CtField ctField) {
                return !ctField.hasAnnotation(Transient.class);
            }
        });
        if (0 < this.classes.size()) {
            for (File file : this.classes) {
                this.enhanceClass(enhancer, file);
            }
        }
        this.getLog().info((CharSequence)"Enhance plugin completed.");
    }

    private void walkDir(File dir) {
        this.walkDir(dir, new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isFile() && pathname.getName().endsWith(MavenEnhancePlugin.CLASS_EXTENSION);
            }
        }, new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        });
    }

    private void walkDir(File dir, FileFilter classesFilter, FileFilter dirFilter) {
        File[] dirs = dir.listFiles(dirFilter);
        for (int i = 0; i < dirs.length; ++i) {
            this.walkDir(dirs[i], classesFilter, dirFilter);
        }
        dirs = null;
        File[] files = dir.listFiles(classesFilter);
        for (int i = 0; i < files.length; ++i) {
            this.classes.add(files[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enhanceClass(Enhancer enhancer, File file) {
        byte[] enhancedBytecode = null;
        FileInputStream is = null;
        CtClass clas = null;
        try {
            is = new FileInputStream(file.toString());
            clas = this.getClassPool().makeClass((InputStream)is);
            if (!clas.hasAnnotation(Entity.class)) {
                this.getLog().debug((CharSequence)"Class $file not an annotated Entity class. skipping...");
            } else {
                enhancedBytecode = enhancer.enhance(clas.getName(), clas.toBytecode());
            }
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)"Unable to enhance class [${file.toString()}]", (Throwable)e);
            return;
        }
        finally {
            try {
                if (null != is) {
                    ((InputStream)is).close();
                }
            }
            catch (IOException ioe) {}
        }
        if (null != enhancedBytecode) {
            if (file.delete()) {
                try {
                    if (!file.createNewFile()) {
                        this.getLog().error((CharSequence)("Unable to recreate class file [" + clas.getName() + "]"));
                    }
                }
                catch (IOException ioe) {}
            } else {
                this.getLog().error((CharSequence)("Unable to delete class file [" + clas.getName() + "]"));
            }
            FileOutputStream outputStream = null;
            try {
                outputStream = new FileOutputStream(file, false);
                outputStream.write(enhancedBytecode);
                outputStream.flush();
            }
            catch (IOException ioe) {
            }
            finally {
                try {
                    if (outputStream != null) {
                        outputStream.close();
                    }
                    clas.detach();
                }
                catch (IOException ignore) {}
            }
        }
    }

    public void setDir(String dir) {
        if (null != dir && !"".equals(dir.trim())) {
            this.dir = dir;
        }
    }

    private ClassPool getClassPool() {
        return this.pool;
    }
}

