/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.ehcache;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.config.ConfigurationFactory;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.ehcache.AbstractEhcacheRegionFactory;
import org.hibernate.cache.ehcache.EhCacheMessageLogger;
import org.hibernate.cache.ehcache.internal.util.HibernateUtil;
import org.hibernate.cfg.Settings;
import org.jboss.logging.Logger;

public class EhCacheRegionFactory
extends AbstractEhcacheRegionFactory {
    private static final EhCacheMessageLogger LOG = (EhCacheMessageLogger)Logger.getMessageLogger(EhCacheMessageLogger.class, (String)EhCacheRegionFactory.class.getName());

    public EhCacheRegionFactory() {
    }

    public EhCacheRegionFactory(Properties prop) {
    }

    public void start(Settings settings, Properties properties) throws CacheException {
        this.settings = settings;
        if (this.manager != null) {
            LOG.attemptToRestartAlreadyStartedEhCacheProvider();
            return;
        }
        try {
            String configurationResourceName = null;
            if (properties != null) {
                configurationResourceName = (String)properties.get("net.sf.ehcache.configurationResourceName");
            }
            if (configurationResourceName == null || configurationResourceName.length() == 0) {
                Configuration configuration = ConfigurationFactory.parseConfiguration();
                this.manager = new CacheManager(configuration);
            } else {
                URL url;
                try {
                    url = new URL(configurationResourceName);
                }
                catch (MalformedURLException e) {
                    url = this.loadResource(configurationResourceName);
                }
                Configuration configuration = HibernateUtil.loadAndCorrectConfiguration(url);
                this.manager = new CacheManager(configuration);
            }
            this.mbeanRegistrationHelper.registerMBean(this.manager, properties);
        }
        catch (net.sf.ehcache.CacheException e) {
            if (e.getMessage().startsWith("Cannot parseConfiguration CacheManager. Attempt to create a new instance of CacheManager using the diskStorePath")) {
                throw new CacheException("Attempt to restart an already started EhCacheRegionFactory. Use sessionFactory.close() between repeated calls to buildSessionFactory. Consider using SingletonEhCacheRegionFactory. Error from ehcache was: " + e.getMessage());
            }
            throw new CacheException((Throwable)e);
        }
    }

    public void stop() {
        try {
            if (this.manager != null) {
                this.mbeanRegistrationHelper.unregisterMBean();
                this.manager.shutdown();
                this.manager = null;
            }
        }
        catch (net.sf.ehcache.CacheException e) {
            throw new CacheException((Throwable)e);
        }
    }
}

