/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa.boot.scan.spi;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.ClassFile;
import javax.persistence.Converter;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.MappedSuperclass;
import org.hibernate.jpa.boot.archive.spi.ArchiveContext;
import org.hibernate.jpa.boot.archive.spi.ArchiveEntry;
import org.hibernate.jpa.boot.archive.spi.ArchiveException;
import org.hibernate.jpa.boot.internal.ClassDescriptorImpl;
import org.hibernate.jpa.boot.scan.spi.AbstractJavaArtifactArchiveEntryHandler;
import org.hibernate.jpa.boot.scan.spi.ScanOptions;
import org.hibernate.jpa.boot.spi.ClassDescriptor;

public class ClassFileArchiveEntryHandler
extends AbstractJavaArtifactArchiveEntryHandler {
    private final Callback callback;

    public ClassFileArchiveEntryHandler(ScanOptions scanOptions, Callback callback) {
        super(scanOptions);
        this.callback = callback;
    }

    @Override
    public void handleEntry(ArchiveEntry entry, ArchiveContext context) {
        ClassFile classFile = this.toClassFile(entry);
        ClassDescriptor classDescriptor = this.toClassDescriptor(classFile, entry);
        if (!this.isListedOrDetectable(context, classDescriptor.getName())) {
            return;
        }
        if (!this.containsClassAnnotationsOfInterest(classFile)) {
            return;
        }
        this.notifyMatchedClass(classDescriptor);
    }

    private ClassFile toClassFile(ArchiveEntry entry) {
        InputStream inputStream = entry.getStreamAccess().accessInputStream();
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        try {
            ClassFile classFile = new ClassFile(dataInputStream);
            return classFile;
        }
        catch (IOException e) {
            throw new ArchiveException("Could not build ClassFile");
        }
        finally {
            try {
                dataInputStream.close();
            }
            catch (Exception exception) {}
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    private boolean containsClassAnnotationsOfInterest(ClassFile cf) {
        AnnotationsAttribute visibleAnnotations = (AnnotationsAttribute)cf.getAttribute("RuntimeVisibleAnnotations");
        if (visibleAnnotations == null) {
            return false;
        }
        return visibleAnnotations.getAnnotation(Entity.class.getName()) != null || visibleAnnotations.getAnnotation(MappedSuperclass.class.getName()) != null || visibleAnnotations.getAnnotation(Embeddable.class.getName()) != null || visibleAnnotations.getAnnotation(Converter.class.getName()) != null;
    }

    protected ClassDescriptor toClassDescriptor(ClassFile classFile, ArchiveEntry entry) {
        return new ClassDescriptorImpl(classFile.getName(), entry.getStreamAccess());
    }

    protected final void notifyMatchedClass(ClassDescriptor classDescriptor) {
        this.callback.locatedClass(classDescriptor);
    }

    public static interface Callback {
        public void locatedClass(ClassDescriptor var1);
    }
}

