/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tooling.gradle;

import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.hibernate.tooling.gradle.EnhancerTask;

public class HibernatePlugin
implements Plugin<Project> {
    public static final String ENHANCE_TASK_NAME = "enhance";

    public void apply(Project project) {
        this.applyEnhancement(project);
    }

    private void applyEnhancement(Project project) {
        project.getLogger().debug("Applying Hibernate enhancement to project.");
        EnhancerTask enhancerTask = (EnhancerTask)project.getTasks().create(ENHANCE_TASK_NAME, EnhancerTask.class);
        enhancerTask.setGroup("build");
        Task classesTask = project.getTasks().getByName("classes");
        enhancerTask.dependsOn(new Object[]{classesTask});
        classesTask.finalizedBy(new Object[]{enhancerTask});
    }
}

