/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.orm.tooling.gradle;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.SourceSet;
import org.hibernate.bytecode.enhance.spi.DefaultEnhancementContext;
import org.hibernate.bytecode.enhance.spi.EnhancementContext;
import org.hibernate.bytecode.enhance.spi.Enhancer;
import org.hibernate.bytecode.enhance.spi.UnloadedClass;
import org.hibernate.bytecode.enhance.spi.UnloadedField;
import org.hibernate.cfg.Environment;
import org.hibernate.orm.tooling.gradle.HibernateExtension;

public class HibernatePlugin
implements Plugin<Project> {
    private final Logger logger = Logging.getLogger(HibernatePlugin.class);

    public void apply(Project project) {
        project.getPlugins().apply("java");
        final HibernateExtension hibernateExtension = new HibernateExtension(project);
        project.getLogger().debug("Adding Hibernate extensions to the build [{}]", (Object)project.getName());
        project.getExtensions().add("hibernate", (Object)hibernateExtension);
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project project) {
                if (hibernateExtension.enhance != null) {
                    HibernatePlugin.this.applyEnhancement(project, hibernateExtension);
                }
            }
        });
    }

    private void applyEnhancement(final Project project, final HibernateExtension hibernateExtension) {
        if (!hibernateExtension.enhance.shouldApply()) {
            project.getLogger().warn("Skipping Hibernate bytecode enhancement since no feature is enabled");
            return;
        }
        for (final SourceSet sourceSet : hibernateExtension.getSourceSets()) {
            project.getLogger().debug("Applying Hibernate enhancement action to SourceSet.{}", (Object)sourceSet.getName());
            Task compileTask = (Task)project.getTasks().findByName(sourceSet.getCompileJavaTaskName());
            compileTask.doLast((Action)new Action<Task>(){

                public void execute(Task task) {
                    project.getLogger().debug("Starting Hibernate enhancement on SourceSet.{}", (Object)sourceSet.getName());
                    final ClassLoader classLoader = HibernatePlugin.this.toClassLoader(sourceSet.getRuntimeClasspath());
                    DefaultEnhancementContext enhancementContext = new DefaultEnhancementContext(){

                        public ClassLoader getLoadingClassLoader() {
                            return classLoader;
                        }

                        public boolean doBiDirectionalAssociationManagement(UnloadedField field) {
                            return hibernateExtension.enhance.getEnableAssociationManagement();
                        }

                        public boolean doDirtyCheckingInline(UnloadedClass classDescriptor) {
                            return hibernateExtension.enhance.getEnableDirtyTracking();
                        }

                        public boolean hasLazyLoadableAttributes(UnloadedClass classDescriptor) {
                            return hibernateExtension.enhance.getEnableLazyInitialization();
                        }

                        public boolean isLazyLoadable(UnloadedField field) {
                            return hibernateExtension.enhance.getEnableLazyInitialization();
                        }

                        public boolean doExtendedEnhancement(UnloadedClass classDescriptor) {
                            return hibernateExtension.enhance.getEnableExtendedEnhancement();
                        }
                    };
                    if (hibernateExtension.enhance.getEnableExtendedEnhancement()) {
                        HibernatePlugin.this.logger.warn("Extended enhancement is enabled. Classes other than entities may be modified. You should consider access the entities using getter/setter methods and disable this property. Use at your own risk.");
                    }
                    Enhancer enhancer = Environment.getBytecodeProvider().getEnhancer((EnhancementContext)enhancementContext);
                    ConfigurableFileTree fileTree = project.fileTree((Object)sourceSet.getOutput().getClassesDir());
                    for (File file : fileTree) {
                        if (!file.getName().endsWith(".class")) continue;
                        byte[] enhancedBytecode = HibernatePlugin.this.doEnhancement(file, enhancer);
                        if (enhancedBytecode != null) {
                            HibernatePlugin.this.writeOutEnhancedClass(enhancedBytecode, file);
                            HibernatePlugin.this.logger.info("Successfully enhanced class [" + file + "]");
                            continue;
                        }
                        HibernatePlugin.this.logger.info("Skipping class [" + file.getAbsolutePath() + "], not an entity nor embeddable");
                    }
                }
            });
        }
    }

    private ClassLoader toClassLoader(FileCollection runtimeClasspath) {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (File file : runtimeClasspath) {
            try {
                urls.add(file.toURI().toURL());
                this.logger.debug("Adding classpath entry for " + file.getAbsolutePath());
            }
            catch (MalformedURLException e) {
                throw new GradleException("Unable to resolve classpath entry to URL : " + file.getAbsolutePath(), (Throwable)e);
            }
        }
        return new URLClassLoader(urls.toArray(new URL[urls.size()]), Enhancer.class.getClassLoader());
    }

    private byte[] doEnhancement(File javaClassFile, Enhancer enhancer) {
        try {
            return enhancer.enhance(javaClassFile);
        }
        catch (Exception e) {
            throw new GradleException("Unable to enhance class : " + javaClassFile, (Throwable)e);
        }
    }

    private void writeOutEnhancedClass(byte[] enhancedBytecode, File file) {
        try {
            if (file.delete()) {
                if (!file.createNewFile()) {
                    this.logger.error("Unable to recreate class file [" + file.getName() + "]");
                }
            } else {
                this.logger.error("Unable to delete class file [" + file.getName() + "]");
            }
        }
        catch (IOException e) {
            this.logger.warn("Problem preparing class file for writing out enhancements [" + file.getName() + "]");
        }
        try {
            FileOutputStream outputStream = new FileOutputStream(file, false);
            try {
                outputStream.write(enhancedBytecode);
                outputStream.flush();
            }
            catch (IOException e) {
                throw new GradleException("Error writing to enhanced class [" + file.getName() + "] to file [" + file.getAbsolutePath() + "]", (Throwable)e);
            }
            finally {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        catch (FileNotFoundException e) {
            throw new GradleException("Error opening class file for writing : " + file.getAbsolutePath(), (Throwable)e);
        }
    }
}

