/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.orm.tooling.gradle;

import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.tasks.SourceSet;
import org.hibernate.orm.tooling.gradle.EnhancementHelper;
import org.hibernate.orm.tooling.gradle.HibernateExtension;

public class HibernatePlugin
implements Plugin<Project> {
    public void apply(Project project) {
        project.getPlugins().apply("java");
        HibernateExtension hibernateExtension = new HibernateExtension(project);
        project.getLogger().debug("Adding Hibernate extensions to the build [{}]", (Object)project.getName());
        project.getExtensions().add("hibernate", (Object)hibernateExtension);
        project.afterEvaluate(p -> this.applyEnhancement((Project)p, hibernateExtension));
    }

    private void applyEnhancement(Project project, HibernateExtension hibernateExtension) {
        if (hibernateExtension.enhance == null || !hibernateExtension.enhance.shouldApply()) {
            project.getLogger().warn("Skipping Hibernate bytecode enhancement since no feature is enabled");
            return;
        }
        for (SourceSet sourceSet : hibernateExtension.getSourceSets()) {
            project.getLogger().debug("Applying Hibernate enhancement action to SourceSet.{}", (Object)sourceSet.getName());
            Task compileTask = (Task)project.getTasks().findByName(sourceSet.getCompileJavaTaskName());
            assert (compileTask != null);
            compileTask.doLast(task -> EnhancementHelper.enhance(sourceSet, hibernateExtension.enhance, project));
        }
    }
}

