/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.test.cache.infinispan.entity;

import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.transaction.TransactionManager;
import junit.framework.AssertionFailedError;
import org.hibernate.cache.infinispan.InfinispanRegionFactory;
import org.hibernate.cache.infinispan.entity.EntityRegionImpl;
import org.hibernate.cache.infinispan.util.Caches;
import org.hibernate.cache.internal.CacheDataDescriptionImpl;
import org.hibernate.cache.spi.CacheDataDescription;
import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.cache.spi.access.EntityRegionAccessStrategy;
import org.hibernate.cfg.Configuration;
import org.hibernate.internal.util.compare.ComparableComparator;
import org.hibernate.test.cache.infinispan.AbstractNonFunctionalTestCase;
import org.hibernate.test.cache.infinispan.NodeEnvironment;
import org.hibernate.test.cache.infinispan.util.CacheTestUtil;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.test.TestingUtil;
import org.infinispan.transaction.tm.BatchModeTransactionManager;
import org.jboss.logging.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class AbstractEntityRegionAccessStrategyTestCase
extends AbstractNonFunctionalTestCase {
    private static final Logger log = Logger.getLogger(AbstractEntityRegionAccessStrategyTestCase.class);
    public static final String REGION_NAME = "test/com.foo.test";
    public static final String KEY_BASE = "KEY";
    public static final String VALUE1 = "VALUE1";
    public static final String VALUE2 = "VALUE2";
    protected static int testCount;
    protected NodeEnvironment localEnvironment;
    protected EntityRegionImpl localEntityRegion;
    protected EntityRegionAccessStrategy localAccessStrategy;
    protected NodeEnvironment remoteEnvironment;
    protected EntityRegionImpl remoteEntityRegion;
    protected EntityRegionAccessStrategy remoteAccessStrategy;
    protected boolean invalidation;
    protected boolean synchronous;
    protected Exception node1Exception;
    protected Exception node2Exception;
    protected AssertionFailedError node1Failure;
    protected AssertionFailedError node2Failure;

    @Before
    public void prepareResources() throws Exception {
        Configuration cfg = AbstractEntityRegionAccessStrategyTestCase.createConfiguration(this.getConfigurationName());
        this.localEnvironment = new NodeEnvironment(cfg);
        this.localEnvironment.prepare();
        this.localEntityRegion = this.localEnvironment.getEntityRegion(REGION_NAME, this.getCacheDataDescription());
        this.localAccessStrategy = this.localEntityRegion.buildAccessStrategy(this.getAccessType());
        this.invalidation = Caches.isInvalidationCache((AdvancedCache)this.localEntityRegion.getCache());
        this.synchronous = Caches.isSynchronousCache((AdvancedCache)this.localEntityRegion.getCache());
        this.avoidConcurrentFlush();
        this.remoteEnvironment = new NodeEnvironment(cfg);
        this.remoteEnvironment.prepare();
        this.remoteEntityRegion = this.remoteEnvironment.getEntityRegion(REGION_NAME, this.getCacheDataDescription());
        this.remoteAccessStrategy = this.remoteEntityRegion.buildAccessStrategy(this.getAccessType());
        this.waitForClusterToForm(new Cache[]{this.localEntityRegion.getCache(), this.remoteEntityRegion.getCache()});
    }

    protected void waitForClusterToForm(Cache ... caches) {
        TestingUtil.blockUntilViewsReceived((int)10000, Arrays.asList(caches));
    }

    protected abstract String getConfigurationName();

    protected static Configuration createConfiguration(String configName) {
        Configuration cfg = CacheTestUtil.buildConfiguration("test", InfinispanRegionFactory.class, true, false);
        cfg.setProperty("hibernate.cache.infinispan.entity.cfg", configName);
        return cfg;
    }

    protected CacheDataDescription getCacheDataDescription() {
        return new CacheDataDescriptionImpl(true, true, ComparableComparator.INSTANCE);
    }

    @After
    public void releaseResources() throws Exception {
        if (this.localEnvironment != null) {
            this.localEnvironment.release();
        }
        if (this.remoteEnvironment != null) {
            this.remoteEnvironment.release();
        }
    }

    protected abstract AccessType getAccessType();

    protected boolean isUsingInvalidation() {
        return this.invalidation;
    }

    protected boolean isSynchronous() {
        return this.synchronous;
    }

    protected void assertThreadsRanCleanly() {
        if (this.node1Failure != null) {
            throw this.node1Failure;
        }
        if (this.node2Failure != null) {
            throw this.node2Failure;
        }
        if (this.node1Exception != null) {
            log.error((Object)"node1 saw an exception", (Throwable)this.node1Exception);
            Assert.assertEquals((String)"node1 saw no exceptions", null, (Object)this.node1Exception);
        }
        if (this.node2Exception != null) {
            log.error((Object)"node2 saw an exception", (Throwable)this.node2Exception);
            Assert.assertEquals((String)"node2 saw no exceptions", null, (Object)this.node2Exception);
        }
    }

    @Test
    public abstract void testCacheConfiguration();

    @Test
    public void testGetRegion() {
        Assert.assertEquals((String)"Correct region", (Object)this.localEntityRegion, (Object)this.localAccessStrategy.getRegion());
    }

    @Test
    public void testPutFromLoad() throws Exception {
        this.putFromLoadTest(false);
    }

    @Test
    public void testPutFromLoadMinimal() throws Exception {
        this.putFromLoadTest(true);
    }

    private void putFromLoadTest(final boolean useMinimalAPI) throws Exception {
        final String KEY = KEY_BASE + testCount++;
        final CountDownLatch writeLatch1 = new CountDownLatch(1);
        final CountDownLatch writeLatch2 = new CountDownLatch(1);
        final CountDownLatch completionLatch = new CountDownLatch(2);
        Thread node1 = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    long txTimestamp = System.currentTimeMillis();
                    BatchModeTransactionManager.getInstance().begin();
                    Assert.assertNull((String)"node1 starts clean", (Object)AbstractEntityRegionAccessStrategyTestCase.this.localAccessStrategy.get((Object)KEY, txTimestamp));
                    writeLatch1.await();
                    if (useMinimalAPI) {
                        AbstractEntityRegionAccessStrategyTestCase.this.localAccessStrategy.putFromLoad((Object)KEY, (Object)AbstractEntityRegionAccessStrategyTestCase.VALUE1, txTimestamp, (Object)new Integer(1), true);
                    } else {
                        AbstractEntityRegionAccessStrategyTestCase.this.localAccessStrategy.putFromLoad((Object)KEY, (Object)AbstractEntityRegionAccessStrategyTestCase.VALUE1, txTimestamp, (Object)new Integer(1));
                    }
                    AbstractEntityRegionAccessStrategyTestCase.this.localAccessStrategy.update((Object)KEY, (Object)AbstractEntityRegionAccessStrategyTestCase.VALUE2, (Object)new Integer(2), (Object)new Integer(1));
                    BatchModeTransactionManager.getInstance().commit();
                }
                catch (Exception e) {
                    log.error((Object)"node1 caught exception", (Throwable)e);
                    AbstractEntityRegionAccessStrategyTestCase.this.node1Exception = e;
                    AbstractEntityRegionAccessStrategyTestCase.this.rollback();
                }
                catch (AssertionFailedError e) {
                    AbstractEntityRegionAccessStrategyTestCase.this.node1Failure = e;
                    AbstractEntityRegionAccessStrategyTestCase.this.rollback();
                }
                finally {
                    writeLatch2.countDown();
                    completionLatch.countDown();
                }
            }
        };
        Thread node2 = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    long txTimestamp = System.currentTimeMillis();
                    BatchModeTransactionManager.getInstance().begin();
                    Assert.assertNull((String)"node1 starts clean", (Object)AbstractEntityRegionAccessStrategyTestCase.this.remoteAccessStrategy.get((Object)KEY, txTimestamp));
                    writeLatch1.countDown();
                    writeLatch2.await();
                    if (useMinimalAPI) {
                        AbstractEntityRegionAccessStrategyTestCase.this.remoteAccessStrategy.putFromLoad((Object)KEY, (Object)AbstractEntityRegionAccessStrategyTestCase.VALUE1, txTimestamp, (Object)new Integer(1), true);
                    } else {
                        AbstractEntityRegionAccessStrategyTestCase.this.remoteAccessStrategy.putFromLoad((Object)KEY, (Object)AbstractEntityRegionAccessStrategyTestCase.VALUE1, txTimestamp, (Object)new Integer(1));
                    }
                    BatchModeTransactionManager.getInstance().commit();
                }
                catch (Exception e) {
                    log.error((Object)"node2 caught exception", (Throwable)e);
                    AbstractEntityRegionAccessStrategyTestCase.this.node2Exception = e;
                    AbstractEntityRegionAccessStrategyTestCase.this.rollback();
                }
                catch (AssertionFailedError e) {
                    AbstractEntityRegionAccessStrategyTestCase.this.node2Failure = e;
                    AbstractEntityRegionAccessStrategyTestCase.this.rollback();
                }
                finally {
                    completionLatch.countDown();
                }
            }
        };
        node1.setDaemon(true);
        node2.setDaemon(true);
        node1.start();
        node2.start();
        Assert.assertTrue((String)"Threads completed", (boolean)completionLatch.await(2L, TimeUnit.SECONDS));
        this.assertThreadsRanCleanly();
        long txTimestamp = System.currentTimeMillis();
        Assert.assertEquals((String)"Correct node1 value", (Object)VALUE2, (Object)this.localAccessStrategy.get((Object)KEY, txTimestamp));
        if (this.isUsingInvalidation()) {
            Assert.assertEquals((String)"Expected node2 value", (Object)VALUE1, (Object)this.remoteAccessStrategy.get((Object)KEY, txTimestamp));
        } else {
            Assert.assertEquals((String)"Correct node2 value", (Object)VALUE2, (Object)this.remoteAccessStrategy.get((Object)KEY, txTimestamp));
        }
    }

    @Test
    public void testInsert() throws Exception {
        final String KEY = KEY_BASE + testCount++;
        final CountDownLatch readLatch = new CountDownLatch(1);
        final CountDownLatch commitLatch = new CountDownLatch(1);
        final CountDownLatch completionLatch = new CountDownLatch(2);
        Thread inserter = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    long txTimestamp = System.currentTimeMillis();
                    BatchModeTransactionManager.getInstance().begin();
                    Assert.assertNull((String)"Correct initial value", (Object)AbstractEntityRegionAccessStrategyTestCase.this.localAccessStrategy.get((Object)KEY, txTimestamp));
                    AbstractEntityRegionAccessStrategyTestCase.this.localAccessStrategy.insert((Object)KEY, (Object)AbstractEntityRegionAccessStrategyTestCase.VALUE1, (Object)new Integer(1));
                    readLatch.countDown();
                    commitLatch.await();
                    BatchModeTransactionManager.getInstance().commit();
                }
                catch (Exception e) {
                    log.error((Object)"node1 caught exception", (Throwable)e);
                    AbstractEntityRegionAccessStrategyTestCase.this.node1Exception = e;
                    AbstractEntityRegionAccessStrategyTestCase.this.rollback();
                }
                catch (AssertionFailedError e) {
                    AbstractEntityRegionAccessStrategyTestCase.this.node1Failure = e;
                    AbstractEntityRegionAccessStrategyTestCase.this.rollback();
                }
                finally {
                    completionLatch.countDown();
                }
            }
        };
        Thread reader = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    long txTimestamp = System.currentTimeMillis();
                    BatchModeTransactionManager.getInstance().begin();
                    readLatch.await();
                    Object expected = null;
                    Assert.assertEquals((String)"Correct initial value", expected, (Object)AbstractEntityRegionAccessStrategyTestCase.this.localAccessStrategy.get((Object)KEY, txTimestamp));
                    BatchModeTransactionManager.getInstance().commit();
                }
                catch (Exception e) {
                    log.error((Object)"node1 caught exception", (Throwable)e);
                    AbstractEntityRegionAccessStrategyTestCase.this.node1Exception = e;
                    AbstractEntityRegionAccessStrategyTestCase.this.rollback();
                }
                catch (AssertionFailedError e) {
                    AbstractEntityRegionAccessStrategyTestCase.this.node1Failure = e;
                    AbstractEntityRegionAccessStrategyTestCase.this.rollback();
                }
                finally {
                    commitLatch.countDown();
                    completionLatch.countDown();
                }
            }
        };
        inserter.setDaemon(true);
        reader.setDaemon(true);
        inserter.start();
        reader.start();
        Assert.assertTrue((String)"Threads completed", (boolean)completionLatch.await(1L, TimeUnit.SECONDS));
        this.assertThreadsRanCleanly();
        long txTimestamp = System.currentTimeMillis();
        Assert.assertEquals((String)"Correct node1 value", (Object)VALUE1, (Object)this.localAccessStrategy.get((Object)KEY, txTimestamp));
        String expected = this.isUsingInvalidation() ? null : VALUE1;
        Assert.assertEquals((String)"Correct node2 value", (Object)expected, (Object)this.remoteAccessStrategy.get((Object)KEY, txTimestamp));
    }

    @Test
    public void testUpdate() throws Exception {
        final String KEY = KEY_BASE + testCount++;
        this.localAccessStrategy.putFromLoad((Object)KEY, (Object)VALUE1, System.currentTimeMillis(), (Object)new Integer(1));
        this.remoteAccessStrategy.putFromLoad((Object)KEY, (Object)VALUE1, System.currentTimeMillis(), (Object)new Integer(1));
        this.sleep(250L);
        final CountDownLatch readLatch = new CountDownLatch(1);
        final CountDownLatch commitLatch = new CountDownLatch(1);
        final CountDownLatch completionLatch = new CountDownLatch(2);
        Thread updater = new Thread("testUpdate-updater"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                boolean readerUnlocked = false;
                try {
                    long txTimestamp = System.currentTimeMillis();
                    BatchModeTransactionManager.getInstance().begin();
                    log.debug((Object)"Transaction began, get initial value");
                    Assert.assertEquals((String)"Correct initial value", (Object)AbstractEntityRegionAccessStrategyTestCase.VALUE1, (Object)AbstractEntityRegionAccessStrategyTestCase.this.localAccessStrategy.get((Object)KEY, txTimestamp));
                    log.debug((Object)"Now update value");
                    AbstractEntityRegionAccessStrategyTestCase.this.localAccessStrategy.update((Object)KEY, (Object)AbstractEntityRegionAccessStrategyTestCase.VALUE2, (Object)new Integer(2), (Object)new Integer(1));
                    log.debug((Object)"Notify the read latch");
                    readLatch.countDown();
                    readerUnlocked = true;
                    log.debug((Object)"Await commit");
                    commitLatch.await();
                    BatchModeTransactionManager.getInstance().commit();
                }
                catch (Exception e) {
                    log.error((Object)"node1 caught exception", (Throwable)e);
                    AbstractEntityRegionAccessStrategyTestCase.this.node1Exception = e;
                    AbstractEntityRegionAccessStrategyTestCase.this.rollback();
                }
                catch (AssertionFailedError e) {
                    AbstractEntityRegionAccessStrategyTestCase.this.node1Failure = e;
                    AbstractEntityRegionAccessStrategyTestCase.this.rollback();
                }
                finally {
                    if (!readerUnlocked) {
                        readLatch.countDown();
                    }
                    log.debug((Object)"Completion latch countdown");
                    completionLatch.countDown();
                }
            }
        };
        Thread reader = new Thread("testUpdate-reader"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    long txTimestamp = System.currentTimeMillis();
                    BatchModeTransactionManager.getInstance().begin();
                    log.debug((Object)"Transaction began, await read latch");
                    readLatch.await();
                    log.debug((Object)"Read latch acquired, verify local access strategy");
                    String expected = AbstractEntityRegionAccessStrategyTestCase.VALUE1;
                    Assert.assertEquals((String)"Correct value", (Object)expected, (Object)AbstractEntityRegionAccessStrategyTestCase.this.localAccessStrategy.get((Object)KEY, txTimestamp));
                    BatchModeTransactionManager.getInstance().commit();
                }
                catch (Exception e) {
                    log.error((Object)"node1 caught exception", (Throwable)e);
                    AbstractEntityRegionAccessStrategyTestCase.this.node1Exception = e;
                    AbstractEntityRegionAccessStrategyTestCase.this.rollback();
                }
                catch (AssertionFailedError e) {
                    AbstractEntityRegionAccessStrategyTestCase.this.node1Failure = e;
                    AbstractEntityRegionAccessStrategyTestCase.this.rollback();
                }
                finally {
                    commitLatch.countDown();
                    log.debug((Object)"Completion latch countdown");
                    completionLatch.countDown();
                }
            }
        };
        updater.setDaemon(true);
        reader.setDaemon(true);
        updater.start();
        reader.start();
        Assert.assertTrue((boolean)completionLatch.await(2L, TimeUnit.SECONDS));
        this.assertThreadsRanCleanly();
        long txTimestamp = System.currentTimeMillis();
        Assert.assertEquals((String)"Correct node1 value", (Object)VALUE2, (Object)this.localAccessStrategy.get((Object)KEY, txTimestamp));
        String expected = this.isUsingInvalidation() ? null : VALUE2;
        Assert.assertEquals((String)"Correct node2 value", (Object)expected, (Object)this.remoteAccessStrategy.get((Object)KEY, txTimestamp));
    }

    @Test
    public void testRemove() throws Exception {
        this.evictOrRemoveTest(false);
    }

    @Test
    public void testRemoveAll() throws Exception {
        this.evictOrRemoveAllTest(false);
    }

    @Test
    public void testEvict() throws Exception {
        this.evictOrRemoveTest(true);
    }

    @Test
    public void testEvictAll() throws Exception {
        this.evictOrRemoveAllTest(true);
    }

    private void evictOrRemoveTest(final boolean evict) throws Exception {
        final String KEY = KEY_BASE + testCount++;
        Assert.assertEquals((long)0L, (long)this.getValidKeyCount(this.localEntityRegion.getCache().keySet()));
        Assert.assertEquals((long)0L, (long)this.getValidKeyCount(this.remoteEntityRegion.getCache().keySet()));
        Assert.assertNull((String)"local is clean", (Object)this.localAccessStrategy.get((Object)KEY, System.currentTimeMillis()));
        Assert.assertNull((String)"remote is clean", (Object)this.remoteAccessStrategy.get((Object)KEY, System.currentTimeMillis()));
        this.localAccessStrategy.putFromLoad((Object)KEY, (Object)VALUE1, System.currentTimeMillis(), (Object)new Integer(1));
        Assert.assertEquals((Object)VALUE1, (Object)this.localAccessStrategy.get((Object)KEY, System.currentTimeMillis()));
        this.remoteAccessStrategy.putFromLoad((Object)KEY, (Object)VALUE1, System.currentTimeMillis(), (Object)new Integer(1));
        Assert.assertEquals((Object)VALUE1, (Object)this.remoteAccessStrategy.get((Object)KEY, System.currentTimeMillis()));
        Caches.withinTx((TransactionManager)this.localEntityRegion.getTransactionManager(), (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                if (evict) {
                    AbstractEntityRegionAccessStrategyTestCase.this.localAccessStrategy.evict((Object)KEY);
                } else {
                    AbstractEntityRegionAccessStrategyTestCase.this.localAccessStrategy.remove((Object)KEY);
                }
                return null;
            }
        });
        Assert.assertEquals(null, (Object)this.localAccessStrategy.get((Object)KEY, System.currentTimeMillis()));
        Assert.assertEquals((long)0L, (long)this.getValidKeyCount(this.localEntityRegion.getCache().keySet()));
        Assert.assertEquals(null, (Object)this.remoteAccessStrategy.get((Object)KEY, System.currentTimeMillis()));
        Assert.assertEquals((long)0L, (long)this.getValidKeyCount(this.remoteEntityRegion.getCache().keySet()));
    }

    private void evictOrRemoveAllTest(final boolean evict) throws Exception {
        String KEY = KEY_BASE + testCount++;
        Assert.assertEquals((long)0L, (long)this.getValidKeyCount(this.localEntityRegion.getCache().keySet()));
        Assert.assertEquals((long)0L, (long)this.getValidKeyCount(this.remoteEntityRegion.getCache().keySet()));
        Assert.assertNull((String)"local is clean", (Object)this.localAccessStrategy.get((Object)KEY, System.currentTimeMillis()));
        Assert.assertNull((String)"remote is clean", (Object)this.remoteAccessStrategy.get((Object)KEY, System.currentTimeMillis()));
        this.localAccessStrategy.putFromLoad((Object)KEY, (Object)VALUE1, System.currentTimeMillis(), (Object)new Integer(1));
        Assert.assertEquals((Object)VALUE1, (Object)this.localAccessStrategy.get((Object)KEY, System.currentTimeMillis()));
        this.sleep(250L);
        this.remoteAccessStrategy.putFromLoad((Object)KEY, (Object)VALUE1, System.currentTimeMillis(), (Object)new Integer(1));
        Assert.assertEquals((Object)VALUE1, (Object)this.remoteAccessStrategy.get((Object)KEY, System.currentTimeMillis()));
        this.sleep(250L);
        Caches.withinTx((TransactionManager)this.localEntityRegion.getTransactionManager(), (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                if (evict) {
                    log.debug((Object)"Call evict all locally");
                    AbstractEntityRegionAccessStrategyTestCase.this.localAccessStrategy.evictAll();
                } else {
                    AbstractEntityRegionAccessStrategyTestCase.this.localAccessStrategy.removeAll();
                }
                return null;
            }
        });
        Assert.assertNull((Object)this.localAccessStrategy.get((Object)KEY, System.currentTimeMillis()));
        Assert.assertEquals((long)0L, (long)this.getValidKeyCount(this.localEntityRegion.getCache().keySet()));
        Assert.assertEquals(null, (Object)this.remoteAccessStrategy.get((Object)KEY, System.currentTimeMillis()));
        Assert.assertEquals((long)0L, (long)this.getValidKeyCount(this.remoteEntityRegion.getCache().keySet()));
        this.remoteAccessStrategy.putFromLoad((Object)KEY, (Object)VALUE1, System.currentTimeMillis(), (Object)new Integer(1));
        Assert.assertEquals((Object)VALUE1, (Object)this.remoteAccessStrategy.get((Object)KEY, System.currentTimeMillis()));
        Assert.assertEquals((long)1L, (long)this.getValidKeyCount(this.remoteEntityRegion.getCache().keySet()));
        this.sleep(250L);
        Assert.assertEquals((String)"local is correct", (Object)(this.isUsingInvalidation() ? null : VALUE1), (Object)this.localAccessStrategy.get((Object)KEY, System.currentTimeMillis()));
        Assert.assertEquals((String)"remote is correct", (Object)VALUE1, (Object)this.remoteAccessStrategy.get((Object)KEY, System.currentTimeMillis()));
    }

    protected void rollback() {
        try {
            BatchModeTransactionManager.getInstance().rollback();
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

