/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.test.cache.infinispan;

import java.util.Set;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.test.cache.infinispan.util.CacheTestSupport;
import org.hibernate.testing.junit4.BaseUnitTestCase;
import org.infinispan.Cache;
import org.jboss.logging.Logger;
import org.junit.After;
import org.junit.Before;

public abstract class AbstractNonFunctionalTestCase
extends BaseUnitTestCase {
    private static final Logger log = Logger.getLogger(AbstractNonFunctionalTestCase.class);
    public static final String REGION_PREFIX = "test";
    private static final String PREFER_IPV4STACK = "java.net.preferIPv4Stack";
    private String preferIPv4Stack;
    private static final String JGROUPS_CFG_FILE = "hibernate.cache.infinispan.jgroups_cfg";
    private String jgroupsCfgFile;
    private CacheTestSupport testSupport = new CacheTestSupport();

    @Before
    public void prepareCacheSupport() throws Exception {
        this.preferIPv4Stack = System.getProperty(PREFER_IPV4STACK);
        System.setProperty(PREFER_IPV4STACK, "true");
        this.jgroupsCfgFile = System.getProperty(JGROUPS_CFG_FILE);
        System.setProperty(JGROUPS_CFG_FILE, "2lc-test-tcp.xml");
        this.testSupport.setUp();
    }

    @After
    public void releaseCachSupport() throws Exception {
        this.testSupport.tearDown();
        if (this.preferIPv4Stack == null) {
            System.clearProperty(PREFER_IPV4STACK);
        } else {
            System.setProperty(PREFER_IPV4STACK, this.preferIPv4Stack);
        }
        if (this.jgroupsCfgFile == null) {
            System.clearProperty(JGROUPS_CFG_FILE);
        } else {
            System.setProperty(JGROUPS_CFG_FILE, this.jgroupsCfgFile);
        }
    }

    protected void registerCache(Cache cache) {
        this.testSupport.registerCache(cache);
    }

    protected void unregisterCache(Cache cache) {
        this.testSupport.unregisterCache(cache);
    }

    protected void registerFactory(RegionFactory factory) {
        this.testSupport.registerFactory(factory);
    }

    protected void unregisterFactory(RegionFactory factory) {
        this.testSupport.unregisterFactory(factory);
    }

    protected CacheTestSupport getCacheTestSupport() {
        return this.testSupport;
    }

    protected void sleep(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            log.warn((Object)"Interrupted during sleep", (Throwable)e);
        }
    }

    protected void avoidConcurrentFlush() {
        this.testSupport.avoidConcurrentFlush();
    }

    protected int getValidKeyCount(Set keys) {
        return keys.size();
    }
}

