/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.test.cache.infinispan.functional;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.transaction.TransactionManager;
import org.hibernate.Session;
import org.hibernate.stat.SecondLevelCacheStatistics;
import org.hibernate.stat.Statistics;
import org.hibernate.test.cache.infinispan.functional.Item;
import org.hibernate.test.cache.infinispan.functional.SingleNodeTestCase;
import org.infinispan.test.TestingUtil;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractFunctionalTestCase
extends SingleNodeTestCase {
    static final Log log = LogFactory.getLog(AbstractFunctionalTestCase.class);

    @Test
    public void testEmptySecondLevelCacheEntry() throws Exception {
        this.sessionFactory().getCache().evictCollectionRegion(Item.class.getName() + ".items");
        Statistics stats = this.sessionFactory().getStatistics();
        stats.clear();
        SecondLevelCacheStatistics statistics = stats.getSecondLevelCacheStatistics(Item.class.getName() + ".items");
        Map cacheEntries = statistics.getEntries();
        Assert.assertEquals((long)0L, (long)cacheEntries.size());
    }

    @Test
    public void testInsertDeleteEntity() throws Exception {
        final Statistics stats = this.sessionFactory().getStatistics();
        stats.clear();
        final Item item = new Item("chris", "Chris's Item");
        TestingUtil.withTx((TransactionManager)this.tm, (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Session s = AbstractFunctionalTestCase.this.openSession();
                s.getTransaction().begin();
                s.persist((Object)item);
                s.getTransaction().commit();
                s.close();
                return null;
            }
        });
        log.info((Object)"Entry persisted, let's load and delete it.");
        TestingUtil.withTx((TransactionManager)this.tm, (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Session s = AbstractFunctionalTestCase.this.openSession();
                s.getTransaction().begin();
                Item found = (Item)s.load(Item.class, (Serializable)item.getId());
                log.info((Object)stats.toString());
                Assert.assertEquals((Object)item.getDescription(), (Object)found.getDescription());
                Assert.assertEquals((long)0L, (long)stats.getSecondLevelCacheMissCount());
                Assert.assertEquals((long)1L, (long)stats.getSecondLevelCacheHitCount());
                s.delete((Object)found);
                s.getTransaction().commit();
                s.close();
                return null;
            }
        });
    }
}

