/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.test.cache.infinispan.functional;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.transaction.TransactionManager;
import org.hibernate.FlushMode;
import org.hibernate.Session;
import org.hibernate.cache.infinispan.InfinispanRegionFactory;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.service.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.service.jta.platform.spi.JtaPlatform;
import org.hibernate.stat.SecondLevelCacheStatistics;
import org.hibernate.test.cache.infinispan.functional.Contact;
import org.hibernate.test.cache.infinispan.functional.Customer;
import org.hibernate.test.cache.infinispan.functional.SingleNodeTestCase;
import org.hibernate.test.cache.infinispan.functional.cluster.DualNodeConnectionProviderImpl;
import org.hibernate.test.cache.infinispan.functional.cluster.DualNodeJtaPlatformImpl;
import org.hibernate.test.cache.infinispan.functional.cluster.DualNodeJtaTransactionManagerImpl;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.junit.Assert;
import org.junit.Test;

public class ConcurrentWriteTest
extends SingleNodeTestCase {
    private static final Log log = LogFactory.getLog(ConcurrentWriteTest.class);
    private static final boolean trace = log.isTraceEnabled();
    private static final int USER_COUNT = 5;
    private static final int ITERATION_COUNT = 150;
    private static final int THINK_TIME_MILLIS = 10;
    private static final long LAUNCH_INTERVAL_MILLIS = 10L;
    private static final Random random = new Random();
    private static volatile boolean TERMINATE_ALL_USERS = false;
    private Set<Integer> customerIDs = new HashSet<Integer>();
    private TransactionManager tm;

    @Override
    public void configure(Configuration cfg) {
        super.configure(cfg);
        cfg.setProperty("hibernate.test.cluster.node.id", "local");
        cfg.setProperty("nodeId", "local");
    }

    @Override
    protected boolean getUseQueryCache() {
        return true;
    }

    @Override
    protected TransactionManager getTransactionManager() {
        return DualNodeJtaTransactionManagerImpl.getInstance("local");
    }

    @Override
    protected Class<? extends RegionFactory> getCacheRegionFactory() {
        return InfinispanRegionFactory.class;
    }

    @Override
    protected Class<? extends ConnectionProvider> getConnectionProviderClass() {
        return DualNodeConnectionProviderImpl.class;
    }

    @Override
    protected Class<? extends JtaPlatform> getJtaPlatform() {
        return DualNodeJtaPlatformImpl.class;
    }

    protected void prepareTest() throws Exception {
        super.prepareTest();
        TERMINATE_ALL_USERS = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanupTest() throws Exception {
        try {
            super.cleanupTest();
        }
        finally {
            this.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPingDb() throws Exception {
        try {
            this.beginTx();
            this.sessionFactory().getCurrentSession().createQuery("from " + Customer.class.getName()).list();
        }
        catch (Exception e) {
            this.setRollbackOnlyTx(e);
        }
        finally {
            this.commitOrRollbackTx();
        }
    }

    @Test
    public void testSingleUser() throws Exception {
        this.sessionFactory().getStatistics().clear();
        Customer customer = this.createCustomer(0);
        Integer customerId = customer.getId();
        this.getCustomerIDs().add(customerId);
        Assert.assertNull((String)"contact exists despite not being added", (Object)this.getFirstContact(customerId));
        SecondLevelCacheStatistics customerSlcs = this.sessionFactory().getStatistics().getSecondLevelCacheStatistics(Customer.class.getName());
        Assert.assertEquals((long)customerSlcs.getPutCount(), (long)1L);
        Assert.assertEquals((long)customerSlcs.getElementCountInMemory(), (long)1L);
        Assert.assertEquals((long)customerSlcs.getEntries().size(), (long)1L);
        log.infof("Add contact to customer {0}", (Object)customerId);
        SecondLevelCacheStatistics contactsCollectionSlcs = this.sessionFactory().getStatistics().getSecondLevelCacheStatistics(Customer.class.getName() + ".contacts");
        Assert.assertEquals((long)1L, (long)contactsCollectionSlcs.getPutCount());
        Assert.assertEquals((long)1L, (long)contactsCollectionSlcs.getElementCountInMemory());
        Assert.assertEquals((long)1L, (long)contactsCollectionSlcs.getEntries().size());
        Contact contact = this.addContact(customerId);
        Assert.assertNotNull((String)"contact returned by addContact is null", (Object)contact);
        Assert.assertEquals((String)"Customer.contacts cache was not invalidated after addContact", (long)0L, (long)contactsCollectionSlcs.getElementCountInMemory());
        Assert.assertNotNull((String)"Contact missing after successful add call", (Object)this.getFirstContact(customerId));
        this.readEveryonesFirstContact();
        this.removeContact(customerId);
        Assert.assertNull((String)"contact still exists after successful remove call", (Object)this.getFirstContact(customerId));
    }

    @Test
    public void testManyUsers() throws Throwable {
        try {
            for (int i = 0; i < 5; ++i) {
                Customer customer = this.createCustomer(0);
                this.getCustomerIDs().add(customer.getId());
            }
            Assert.assertEquals((String)"failed to create enough Customers", (long)5L, (long)this.getCustomerIDs().size());
            ExecutorService executor = Executors.newFixedThreadPool(5);
            CyclicBarrier barrier = new CyclicBarrier(6);
            ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>(5);
            for (Integer n : this.getCustomerIDs()) {
                Future<Void> future = executor.submit(new UserRunner(n, barrier));
                futures.add(future);
                Thread.sleep(10L);
            }
            barrier.await(2L, TimeUnit.MINUTES);
            log.info((Object)"All threads finished, let's shutdown the executor and check whether any exceptions were reported");
            for (Future future : futures) {
                future.get();
            }
            log.info((Object)"All future gets checked");
        }
        catch (Throwable t) {
            log.error((Object)"Error running test", t);
            throw t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() throws Exception {
        this.getCustomerIDs().clear();
        String deleteContactHQL = "delete from Contact";
        String deleteCustomerHQL = "delete from Customer";
        this.beginTx();
        try {
            Session session = this.sessionFactory().getCurrentSession();
            session.createQuery(deleteContactHQL).setFlushMode(FlushMode.AUTO).executeUpdate();
            session.createQuery(deleteCustomerHQL).setFlushMode(FlushMode.AUTO).executeUpdate();
        }
        catch (Exception e) {
            this.setRollbackOnlyTx(e);
        }
        finally {
            this.commitOrRollbackTx();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Customer createCustomer(int nameSuffix) throws Exception {
        Customer customer = null;
        this.beginTx();
        try {
            customer = new Customer();
            customer.setName("customer_" + nameSuffix);
            customer.setContacts(new HashSet<Contact>());
            this.sessionFactory().getCurrentSession().persist((Object)customer);
        }
        catch (Exception e) {
            this.setRollbackOnlyTx(e);
        }
        finally {
            this.commitOrRollbackTx();
        }
        return customer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readEveryonesFirstContact() throws Exception {
        this.beginTx();
        try {
            for (Integer customerId : this.getCustomerIDs()) {
                if (TERMINATE_ALL_USERS) {
                    this.setRollbackOnlyTx();
                    return;
                }
                Customer customer = (Customer)this.sessionFactory().getCurrentSession().load(Customer.class, (Serializable)customerId);
                Set<Contact> contacts = customer.getContacts();
                if (contacts.isEmpty()) continue;
                contacts.iterator().next();
            }
        }
        catch (Exception e) {
            this.setRollbackOnlyTx(e);
        }
        finally {
            this.commitOrRollbackTx();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Contact getFirstContact(Integer customerId) throws Exception {
        assert (customerId != null);
        Contact firstContact = null;
        this.beginTx();
        try {
            Customer customer = (Customer)this.sessionFactory().getCurrentSession().load(Customer.class, (Serializable)customerId);
            Set<Contact> contacts = customer.getContacts();
            Contact contact = firstContact = contacts.isEmpty() ? null : contacts.iterator().next();
            if (TERMINATE_ALL_USERS) {
                this.setRollbackOnlyTx();
            }
        }
        catch (Exception e) {
            this.setRollbackOnlyTx(e);
        }
        finally {
            this.commitOrRollbackTx();
        }
        return firstContact;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Contact addContact(Integer customerId) throws Exception {
        assert (customerId != null);
        Contact contact = null;
        this.beginTx();
        try {
            Customer customer = (Customer)this.sessionFactory().getCurrentSession().load(Customer.class, (Serializable)customerId);
            contact = new Contact();
            contact.setName("contact name");
            contact.setTlf("wtf is tlf?");
            contact.setCustomer(customer);
            customer.getContacts().add(contact);
            if (TERMINATE_ALL_USERS) {
                this.setRollbackOnlyTx();
            }
        }
        catch (Exception e) {
            this.setRollbackOnlyTx(e);
        }
        finally {
            this.commitOrRollbackTx();
        }
        return contact;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeContact(Integer customerId) throws Exception {
        assert (customerId != null);
        this.beginTx();
        try {
            Customer customer = (Customer)this.sessionFactory().getCurrentSession().load(Customer.class, (Serializable)customerId);
            Set<Contact> contacts = customer.getContacts();
            if (contacts.size() != 1) {
                throw new IllegalStateException("can't remove contact: customer id=" + customerId + " expected exactly 1 contact, " + "actual count=" + contacts.size());
            }
            Contact contact = contacts.iterator().next();
            contacts.remove(contact);
            contact.setCustomer(null);
            if (TERMINATE_ALL_USERS) {
                this.setRollbackOnlyTx();
            }
        }
        catch (Exception e) {
            this.setRollbackOnlyTx(e);
        }
        finally {
            this.commitOrRollbackTx();
        }
    }

    public Set<Integer> getCustomerIDs() {
        return this.customerIDs;
    }

    private String statusOfRunnersToString(Set<UserRunner> runners) {
        assert (runners != null);
        StringBuilder sb = new StringBuilder("TEST CONFIG [userCount=5, iterationsPerUser=150, thinkTimeMillis=10]  STATE of UserRunners: ");
        for (UserRunner r : runners) {
            sb.append(r.toString() + System.getProperty("line.separator"));
        }
        return sb.toString();
    }

    public static String getStackTrace(Throwable throwable) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        throwable.printStackTrace(pw);
        return sw.getBuffer().toString();
    }

    private void thinkRandomTime() {
        try {
            Thread.sleep(random.nextInt(10));
        }
        catch (InterruptedException ex) {
            throw new RuntimeException("sleep interrupted", ex);
        }
        if (TERMINATE_ALL_USERS) {
            throw new RuntimeException("told to terminate (because a UserRunner had failed)");
        }
    }

    class UserRunner
    implements Callable<Void> {
        private final CyclicBarrier barrier;
        private final Integer customerId;
        private int completedIterations = 0;
        private Throwable causeOfFailure;

        public UserRunner(Integer cId, CyclicBarrier barrier) {
            assert (cId != null);
            this.customerId = cId;
            this.barrier = barrier;
        }

        private boolean contactExists() throws Exception {
            return ConcurrentWriteTest.this.getFirstContact(this.customerId) != null;
        }

        @Override
        public Void call() throws Exception {
            Thread.currentThread().setName("UserRunnerThread-" + this.getCustomerId());
            log.info((Object)"Wait for all executions paths to be ready to perform calls");
            try {
                for (int i = 0; i < 150 && !TERMINATE_ALL_USERS; ++i) {
                    this.contactExists();
                    if (trace) {
                        log.trace((Object)("Add contact for customer " + this.customerId));
                    }
                    ConcurrentWriteTest.this.addContact(this.customerId);
                    if (trace) {
                        log.trace((Object)"Added contact");
                    }
                    ConcurrentWriteTest.this.thinkRandomTime();
                    this.contactExists();
                    ConcurrentWriteTest.this.thinkRandomTime();
                    if (trace) {
                        log.trace((Object)"Read all customers' first contact");
                    }
                    ConcurrentWriteTest.this.readEveryonesFirstContact();
                    if (trace) {
                        log.trace((Object)"Read completed");
                    }
                    ConcurrentWriteTest.this.thinkRandomTime();
                    if (trace) {
                        log.trace((Object)("Remove contact of customer" + this.customerId));
                    }
                    ConcurrentWriteTest.this.removeContact(this.customerId);
                    if (trace) {
                        log.trace((Object)"Removed contact");
                    }
                    this.contactExists();
                    ConcurrentWriteTest.this.thinkRandomTime();
                    ++this.completedIterations;
                    if (!trace) continue;
                    log.tracef("Iteration completed {0}", (Object)this.completedIterations);
                }
            }
            catch (Throwable t) {
                TERMINATE_ALL_USERS = true;
                log.error((Object)"Error", t);
                throw new Exception(t);
            }
            finally {
                log.info((Object)"Wait for all execution paths to finish");
                this.barrier.await();
            }
            return null;
        }

        public boolean isSuccess() {
            return 150 == this.getCompletedIterations();
        }

        public int getCompletedIterations() {
            return this.completedIterations;
        }

        public Throwable getCauseOfFailure() {
            return this.causeOfFailure;
        }

        public Integer getCustomerId() {
            return this.customerId;
        }

        public String toString() {
            return super.toString() + "[customerId=" + this.getCustomerId() + " iterationsCompleted=" + this.getCompletedIterations() + " completedAll=" + this.isSuccess() + " causeOfFailure=" + (this.causeOfFailure != null ? ConcurrentWriteTest.getStackTrace(this.causeOfFailure) : "") + "] ";
        }
    }
}

