/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.test.cache.infinispan.functional.classloader;

import org.hibernate.SessionFactory;
import org.hibernate.cache.internal.StandardQueryCache;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.test.cache.infinispan.functional.classloader.Account;
import org.hibernate.test.cache.infinispan.functional.classloader.AccountHolder;
import org.hibernate.test.cache.infinispan.functional.classloader.CacheAccessListener;
import org.hibernate.test.cache.infinispan.functional.classloader.ClassLoaderTestDAO;
import org.hibernate.test.cache.infinispan.functional.classloader.SelectedClassnameClassLoader;
import org.hibernate.test.cache.infinispan.functional.cluster.ClusterAwareRegionFactory;
import org.hibernate.test.cache.infinispan.functional.cluster.DualNodeJtaTransactionManagerImpl;
import org.hibernate.test.cache.infinispan.functional.cluster.DualNodeTestCase;
import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.jboss.logging.Logger;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

public class IsolatedClassLoaderTest
extends DualNodeTestCase {
    private static final Logger log = Logger.getLogger(IsolatedClassLoaderTest.class);
    protected static final long SLEEP_TIME = 300L;
    private Cache localQueryCache;
    private CacheAccessListener localQueryListener;
    private Cache remoteQueryCache;
    private CacheAccessListener remoteQueryListener;
    private static ClassLoader originalTCCL;
    private static ClassLoader visibleClassesCl;

    @BeforeClass
    public static void prepareClassLoader() {
        String packageName = IsolatedClassLoaderTest.class.getPackage().getName();
        String[] classes = new String[]{packageName + ".Account", packageName + ".AccountHolder"};
        originalTCCL = Thread.currentThread().getContextClassLoader();
        ClassLoader parent = originalTCCL == null ? IsolatedClassLoaderTest.class.getClassLoader() : originalTCCL;
        SelectedClassnameClassLoader selectedTCCL = new SelectedClassnameClassLoader(null, null, classes, parent);
        SelectedClassnameClassLoader visible = new SelectedClassnameClassLoader(classes, null, null, selectedTCCL);
        Thread.currentThread().setContextClassLoader(visible);
    }

    @AfterClass
    public static void resetClassLoader() {
        ClusterAwareRegionFactory.clearCacheManagers();
        DualNodeJtaTransactionManagerImpl.cleanupTransactions();
        DualNodeJtaTransactionManagerImpl.cleanupTransactionManagers();
        Thread.currentThread().setContextClassLoader(originalTCCL);
    }

    @Override
    public String[] getMappings() {
        return new String[]{"cache/infinispan/functional/classloader/Account.hbm.xml"};
    }

    @Override
    protected void standardConfigure(org.hibernate.cfg.Configuration cfg) {
        super.standardConfigure(cfg);
        cfg.setProperty("hibernate.cache.infinispan.query.cfg", "replicated-query");
        cfg.setProperty("hibernate.cache.infinispan.AccountRegion.cfg", "replicated-query");
    }

    @Override
    protected void cleanupTransactionManagement() {
        DualNodeJtaTransactionManagerImpl.cleanupTransactions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void cleanupTest() throws Exception {
        try {
            this.sessionFactory().getCache().evictEntityRegion(Account.class.getName());
            if (this.localQueryCache != null && this.localQueryListener != null) {
                this.localQueryCache.removeListener((Object)this.localQueryListener);
            }
            if (this.remoteQueryCache != null && this.remoteQueryListener != null) {
                this.remoteQueryCache.removeListener((Object)this.remoteQueryListener);
            }
        }
        finally {
            super.cleanupTest();
        }
    }

    @Ignore(value="Infinispan caches now use whichever classloader is associated on construction, i.e. deployment JPA app, so does not rely on TCCL.")
    @Test
    public void testIsolatedSetup() throws Exception {
        EmbeddedCacheManager localManager = ClusterAwareRegionFactory.getCacheManager("local");
        Cache localReplicatedCache = localManager.getCache("replicated-entity");
        EmbeddedCacheManager remoteManager = ClusterAwareRegionFactory.getCacheManager("remote");
        Cache remoteReplicatedCache = remoteManager.getCache("replicated-entity");
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(cl.getParent());
        log.info((Object)("TCCL is " + cl.getParent()));
        Account acct = new Account();
        acct.setAccountHolder(new AccountHolder());
        try {
            localReplicatedCache.put((Object)"isolated1", (Object)acct);
            remoteReplicatedCache.get((Object)"isolated1");
            Assert.fail((String)"Should not have succeeded in putting acct -- classloader not isolated");
        }
        catch (Exception e) {
            if (e.getCause() instanceof ClassNotFoundException) {
                log.info((Object)"Caught exception as desired", (Throwable)e);
            }
            throw new IllegalStateException("Unexpected exception", e);
        }
        Thread.currentThread().setContextClassLoader(cl);
        log.info((Object)("TCCL is " + cl));
        localReplicatedCache.put((Object)"isolated2", (Object)acct);
        Assert.assertEquals((Object)acct.getClass().getName(), (Object)remoteReplicatedCache.get((Object)"isolated2").getClass().getName());
    }

    @Ignore(value="Infinispan caches now use whichever classloader is associated on construction, i.e. deployment JPA app, so does not rely on TCCL.")
    @Test
    public void testClassLoaderHandlingNamedQueryRegion() throws Exception {
        this.rebuildSessionFactory();
        this.queryTest(true);
    }

    @Ignore(value="Infinispan caches now use whichever classloader is associated on construction, i.e. deployment JPA app, so does not rely on TCCL.")
    @Test
    public void testClassLoaderHandlingStandardQueryCache() throws Exception {
        this.rebuildSessionFactory();
        this.queryTest(false);
    }

    protected void queryTest(boolean useNamedRegion) throws Exception {
        String cacheName;
        EmbeddedCacheManager localManager = ClusterAwareRegionFactory.getCacheManager("local");
        EmbeddedCacheManager remoteManager = ClusterAwareRegionFactory.getCacheManager("remote");
        if (useNamedRegion) {
            cacheName = "AccountRegion";
            localManager.defineConfiguration(cacheName, "replicated-query", new Configuration());
            remoteManager.defineConfiguration(cacheName, "replicated-query", new Configuration());
        } else {
            cacheName = "replicated-query";
        }
        this.localQueryCache = localManager.getCache(cacheName);
        this.localQueryListener = new CacheAccessListener();
        this.localQueryCache.addListener((Object)this.localQueryListener);
        DualNodeJtaTransactionManagerImpl localTM = DualNodeJtaTransactionManagerImpl.getInstance("local");
        this.remoteQueryCache = remoteManager.getCache(cacheName);
        this.remoteQueryListener = new CacheAccessListener();
        this.remoteQueryCache.addListener((Object)this.remoteQueryListener);
        DualNodeJtaTransactionManagerImpl remoteTM = DualNodeJtaTransactionManagerImpl.getInstance("remote");
        SessionFactoryImplementor localFactory = this.sessionFactory();
        SessionFactoryImplementor remoteFactory = this.secondNodeEnvironment().getSessionFactory();
        ClassLoaderTestDAO dao0 = new ClassLoaderTestDAO((SessionFactory)localFactory, localTM);
        ClassLoaderTestDAO dao1 = new ClassLoaderTestDAO((SessionFactory)remoteFactory, remoteTM);
        this.setupEntities(dao0);
        String branch = "63088";
        Assert.assertEquals((String)(branch + " has correct # of accounts"), (long)6L, (long)dao0.getCountForBranch(branch, useNamedRegion));
        Assert.assertEquals((String)"Query cache used", (long)1L, (long)this.localQueryListener.getSawRegionModificationCount());
        this.localQueryListener.clearSawRegionModification();
        this.sleep(300L);
        Assert.assertEquals((String)"Query cache used", (long)1L, (long)this.remoteQueryListener.getSawRegionModificationCount());
        this.remoteQueryListener.clearSawRegionModification();
        log.info((Object)("Repeat first query (get count for branch + " + branch + " ) on remote node"));
        Assert.assertEquals((String)"63088 has correct # of accounts", (long)6L, (long)dao1.getCountForBranch(branch, useNamedRegion));
        Assert.assertEquals((String)"Query cache used", (long)1L, (long)this.remoteQueryListener.getSawRegionModificationCount());
        this.remoteQueryListener.clearSawRegionModification();
        this.sleep(300L);
        Assert.assertEquals((String)"Query cache used", (long)1L, (long)this.localQueryListener.getSawRegionModificationCount());
        this.localQueryListener.clearSawRegionModification();
        log.info((Object)"First query on node 1 done");
        this.sleep(300L);
        log.info((Object)"Do query Smith's branch");
        Assert.assertEquals((String)"Correct branch for Smith", (Object)"94536", (Object)dao0.getBranch(dao0.getSmith(), useNamedRegion));
        log.info((Object)"Do query Jone's balance");
        Assert.assertEquals((String)"Correct high balances for Jones", (long)40L, (long)dao0.getTotalBalance(dao0.getJones(), useNamedRegion));
        Assert.assertEquals((String)"Query cache used", (long)2L, (long)this.localQueryListener.getSawRegionModificationCount());
        this.localQueryListener.clearSawRegionModification();
        log.info((Object)"Second set of queries on node0 done");
        this.sleep(300L);
        Assert.assertEquals((String)"Query cache remotely modified", (long)2L, (long)this.remoteQueryListener.getSawRegionModificationCount());
        this.remoteQueryListener.clearSawRegionModification();
        log.info((Object)"Repeat second set of queries on node1");
        log.info((Object)"Again query Smith's branch");
        Assert.assertEquals((String)"Correct branch for Smith", (Object)"94536", (Object)dao1.getBranch(dao1.getSmith(), useNamedRegion));
        log.info((Object)"Again query Jone's balance");
        Assert.assertEquals((String)"Correct high balances for Jones", (long)40L, (long)dao1.getTotalBalance(dao1.getJones(), useNamedRegion));
        Assert.assertEquals((String)"Query cache modified", (long)0L, (long)this.remoteQueryListener.getSawRegionModificationCount());
        Assert.assertEquals((String)"Query cache accessed", (long)2L, (long)this.remoteQueryListener.getSawRegionAccessCount());
        this.remoteQueryListener.clearSawRegionAccess();
        log.info((Object)"Second set of queries on node1 done");
        this.sleep(300L);
        this.modifyEntities(dao1);
        this.sleep(300L);
        Assert.assertEquals((String)"63088 has correct # of accounts", (long)7L, (long)dao0.getCountForBranch("63088", useNamedRegion));
        Assert.assertEquals((String)"Correct branch for Smith", (Object)"63088", (Object)dao0.getBranch(dao0.getSmith(), useNamedRegion));
        Assert.assertEquals((String)"Correct high balances for Jones", (long)50L, (long)dao0.getTotalBalance(dao0.getJones(), useNamedRegion));
        log.info((Object)"Third set of queries on node0 done");
    }

    protected void setupEntities(ClassLoaderTestDAO dao) throws Exception {
        dao.cleanup();
        dao.createAccount(dao.getSmith(), new Integer(1001), new Integer(5), "94536");
        dao.createAccount(dao.getSmith(), new Integer(1002), new Integer(15), "94536");
        dao.createAccount(dao.getSmith(), new Integer(1003), new Integer(20), "94536");
        dao.createAccount(dao.getJones(), new Integer(2001), new Integer(5), "63088");
        dao.createAccount(dao.getJones(), new Integer(2002), new Integer(15), "63088");
        dao.createAccount(dao.getJones(), new Integer(2003), new Integer(20), "63088");
        dao.createAccount(dao.getBarney(), new Integer(3001), new Integer(5), "63088");
        dao.createAccount(dao.getBarney(), new Integer(3002), new Integer(15), "63088");
        dao.createAccount(dao.getBarney(), new Integer(3003), new Integer(20), "63088");
        log.info((Object)"Standard entities created");
    }

    protected void resetRegionUsageState(CacheAccessListener localListener, CacheAccessListener remoteListener) {
        String stdName = StandardQueryCache.class.getName();
        String acctName = Account.class.getName();
        localListener.getSawRegionModification(stdName);
        localListener.getSawRegionModification(acctName);
        localListener.getSawRegionAccess(stdName);
        localListener.getSawRegionAccess(acctName);
        remoteListener.getSawRegionModification(stdName);
        remoteListener.getSawRegionModification(acctName);
        remoteListener.getSawRegionAccess(stdName);
        remoteListener.getSawRegionAccess(acctName);
        log.info((Object)"Region usage state cleared");
    }

    protected void modifyEntities(ClassLoaderTestDAO dao) throws Exception {
        dao.updateAccountBranch(1001, "63088");
        dao.updateAccountBalance(2001, 15);
        log.info((Object)"Entities modified");
    }
}

