/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.test.cache.infinispan.functional.cluster;

import java.util.Set;
import java.util.concurrent.Callable;
import javax.transaction.TransactionManager;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.cache.spi.NaturalIdCacheKey;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.test.cache.infinispan.functional.Citizen;
import org.hibernate.test.cache.infinispan.functional.NaturalIdOnManyToOne;
import org.hibernate.test.cache.infinispan.functional.State;
import org.hibernate.test.cache.infinispan.functional.cluster.ClusterAwareRegionFactory;
import org.hibernate.test.cache.infinispan.functional.cluster.DualNodeJtaTransactionManagerImpl;
import org.hibernate.test.cache.infinispan.functional.cluster.DualNodeTestCase;
import org.infinispan.Cache;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryVisited;
import org.infinispan.notifications.cachelistener.event.CacheEntryVisitedEvent;
import org.infinispan.test.TestingUtil;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.jboss.util.collection.ConcurrentSet;
import org.junit.Assert;
import org.junit.Test;

public class NaturalIdInvalidationTestCase
extends DualNodeTestCase {
    private static final Log log = LogFactory.getLog(NaturalIdInvalidationTestCase.class);
    private static final long SLEEP_TIME = 50L;
    private static final Integer CUSTOMER_ID = new Integer(1);
    private static int test = 0;

    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Citizen.class, State.class, NaturalIdOnManyToOne.class};
    }

    @Test
    public void testAll() throws Exception {
        log.info((Object)"*** testAll()");
        EmbeddedCacheManager localManager = ClusterAwareRegionFactory.getCacheManager("local");
        Cache localNaturalIdCache = localManager.getCache(Citizen.class.getName() + "##NaturalId");
        MyListener localListener = new MyListener("local");
        localNaturalIdCache.addListener((Object)localListener);
        DualNodeJtaTransactionManagerImpl localTM = DualNodeJtaTransactionManagerImpl.getInstance("local");
        EmbeddedCacheManager remoteManager = ClusterAwareRegionFactory.getCacheManager("remote");
        Cache remoteNaturalIdCache = remoteManager.getCache(Citizen.class.getName() + "##NaturalId");
        MyListener remoteListener = new MyListener("remote");
        remoteNaturalIdCache.addListener((Object)remoteListener);
        DualNodeJtaTransactionManagerImpl remoteTM = DualNodeJtaTransactionManagerImpl.getInstance("remote");
        SessionFactoryImplementor localFactory = this.sessionFactory();
        SessionFactoryImplementor remoteFactory = this.secondNodeEnvironment().getSessionFactory();
        try {
            Assert.assertTrue((boolean)remoteListener.isEmpty());
            Assert.assertTrue((boolean)localListener.isEmpty());
            this.saveSomeCitizens(localTM, (SessionFactory)localFactory);
            Assert.assertTrue((boolean)remoteListener.isEmpty());
            Assert.assertTrue((boolean)localListener.isEmpty());
            this.sleep(50L);
            log.debug((Object)"Find node 0");
            this.getCitizenWithCriteria(localTM, (SessionFactory)localFactory);
            this.sleep(50L);
            log.debug((Object)"Find(2) node 0");
            localListener.clear();
            this.getCitizenWithCriteria(localTM, (SessionFactory)localFactory);
            log.debug((Object)"Check cache 0");
            this.assertLoadedFromCache(localListener, "1234");
            log.debug((Object)"Find node 1");
            this.getCitizenWithCriteria(remoteTM, (SessionFactory)remoteFactory);
            log.debug((Object)"Find(2) node 1");
            remoteListener.clear();
            this.getCitizenWithCriteria(remoteTM, (SessionFactory)remoteFactory);
            log.debug((Object)"Check cache 1");
            this.assertLoadedFromCache(remoteListener, "1234");
            remoteListener.clear();
            this.deleteCitizenWithCriteria(remoteTM, (SessionFactory)remoteFactory);
            this.sleep(250L);
            Set localKeys = localNaturalIdCache.keySet();
            Assert.assertEquals((long)1L, (long)localKeys.size());
            localKeys.toString().contains("000");
        }
        catch (Exception e) {
            try {
                log.error((Object)"Error", (Throwable)e);
                throw e;
            }
            catch (Throwable throwable) {
                TestingUtil.withTx((TransactionManager)localTM, (Callable)new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        Session s = NaturalIdInvalidationTestCase.this.sessionFactory().openSession();
                        s.beginTransaction();
                        s.createQuery("delete NaturalIdOnManyToOne").executeUpdate();
                        s.createQuery("delete Citizen").executeUpdate();
                        s.createQuery("delete State").executeUpdate();
                        s.getTransaction().commit();
                        s.close();
                        return null;
                    }
                });
                throw throwable;
            }
        }
        TestingUtil.withTx((TransactionManager)localTM, (Callable)new /* invalid duplicate definition of identical inner class */);
    }

    private void assertLoadedFromCache(MyListener localListener, String id) {
        for (String visited : localListener.visited) {
            if (!visited.contains(id)) continue;
            return;
        }
        Assert.fail((String)("Citizen (" + id + ") should have present in the cache"));
    }

    private void saveSomeCitizens(TransactionManager tm, final SessionFactory sf) throws Exception {
        final Citizen c1 = new Citizen();
        c1.setFirstname("Emmanuel");
        c1.setLastname("Bernard");
        c1.setSsn("1234");
        final State france = new State();
        france.setName("Ile de France");
        c1.setState(france);
        final Citizen c2 = new Citizen();
        c2.setFirstname("Gavin");
        c2.setLastname("King");
        c2.setSsn("000");
        final State australia = new State();
        australia.setName("Australia");
        c2.setState(australia);
        TestingUtil.withTx((TransactionManager)tm, (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Session s = sf.openSession();
                Transaction tx = s.beginTransaction();
                s.persist((Object)australia);
                s.persist((Object)france);
                s.persist((Object)c1);
                s.persist((Object)c2);
                tx.commit();
                s.close();
                return null;
            }
        });
    }

    private void getCitizenWithCriteria(TransactionManager tm, final SessionFactory sf) throws Exception {
        TestingUtil.withTx((TransactionManager)tm, (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Session s = sf.openSession();
                Transaction tx = s.beginTransaction();
                State france = NaturalIdInvalidationTestCase.this.getState(s, "Ile de France");
                Criteria criteria = s.createCriteria(Citizen.class);
                criteria.add((Criterion)Restrictions.naturalId().set("ssn", (Object)"1234").set("state", (Object)france));
                criteria.setCacheable(true);
                criteria.list();
                tx.commit();
                s.close();
                return null;
            }
        });
    }

    private void deleteCitizenWithCriteria(TransactionManager tm, final SessionFactory sf) throws Exception {
        TestingUtil.withTx((TransactionManager)tm, (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Session s = sf.openSession();
                Transaction tx = s.beginTransaction();
                State france = NaturalIdInvalidationTestCase.this.getState(s, "Ile de France");
                Criteria criteria = s.createCriteria(Citizen.class);
                criteria.add((Criterion)Restrictions.naturalId().set("ssn", (Object)"1234").set("state", (Object)france));
                criteria.setCacheable(true);
                Citizen c = (Citizen)criteria.uniqueResult();
                s.delete((Object)c);
                tx.commit();
                s.close();
                return null;
            }
        });
    }

    private State getState(Session s, String name) {
        Criteria criteria = s.createCriteria(State.class);
        criteria.add((Criterion)Restrictions.eq((String)"name", (Object)name));
        criteria.setCacheable(true);
        return (State)criteria.list().get(0);
    }

    @Listener
    public static class MyListener {
        private static final Log log = LogFactory.getLog(MyListener.class);
        private Set<String> visited = new ConcurrentSet();
        private final String name;

        public MyListener(String name) {
            this.name = name;
        }

        public void clear() {
            this.visited.clear();
        }

        public boolean isEmpty() {
            return this.visited.isEmpty();
        }

        @CacheEntryVisited
        public void nodeVisited(CacheEntryVisitedEvent event) {
            log.debug((Object)event.toString());
            if (!event.isPre()) {
                NaturalIdCacheKey cacheKey = (NaturalIdCacheKey)event.getKey();
                this.visited.add(cacheKey.toString());
            }
        }
    }
}

