/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.infinispan.query;

import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.infinispan.impl.BaseTransactionalDataRegion;
import org.hibernate.cache.infinispan.util.Caches;
import org.hibernate.cache.spi.QueryResultsRegion;
import org.hibernate.cache.spi.RegionFactory;
import org.infinispan.AdvancedCache;
import org.infinispan.configuration.cache.TransactionConfiguration;
import org.infinispan.context.Flag;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class QueryResultsRegionImpl
extends BaseTransactionalDataRegion
implements QueryResultsRegion {
    private static final Log log = LogFactory.getLog(QueryResultsRegionImpl.class);
    private final AdvancedCache evictCache;
    private final AdvancedCache putCache;
    private final AdvancedCache getCache;
    private final ConcurrentMap<Transaction, Map<Object, PostTransactionQueryUpdate>> transactionContext = new ConcurrentHashMap<Transaction, Map<Object, PostTransactionQueryUpdate>>();
    private final boolean putCacheRequiresTransaction;

    public QueryResultsRegionImpl(AdvancedCache cache, String name, RegionFactory factory) {
        super(cache, name, null, factory);
        boolean localOnly = Caches.isInvalidationCache(cache);
        this.evictCache = localOnly ? Caches.localCache(cache) : cache;
        this.putCache = localOnly ? Caches.failSilentWriteCache(cache, Flag.CACHE_MODE_LOCAL) : Caches.failSilentWriteCache(cache);
        this.getCache = Caches.failSilentReadCache(cache);
        TransactionConfiguration transactionConfiguration = this.putCache.getCacheConfiguration().transaction();
        boolean transactional = transactionConfiguration.transactionMode() != TransactionMode.NON_TRANSACTIONAL;
        this.putCacheRequiresTransaction = transactional && !transactionConfiguration.autoCommit();
    }

    public void evict(Object key) throws CacheException {
        for (Map map : this.transactionContext.values()) {
            PostTransactionQueryUpdate update = (PostTransactionQueryUpdate)map.remove(key);
            if (update == null) continue;
            update.setValue(null);
        }
        this.evictCache.remove(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evictAll() throws CacheException {
        for (Map map : this.transactionContext.values()) {
            for (PostTransactionQueryUpdate update : map.values()) {
                update.setValue(null);
            }
        }
        this.transactionContext.clear();
        Transaction tx = this.suspend();
        try {
            this.invalidateRegion();
            Caches.broadcastEvictAll(this.cache);
        }
        finally {
            this.resume(tx);
        }
    }

    public Object get(Object key) throws CacheException {
        boolean skipCacheStore = false;
        if (!this.isValid()) {
            skipCacheStore = true;
        }
        if (!this.checkValid()) {
            return null;
        }
        TransactionManager tm = this.getTransactionManager();
        try {
            Object value;
            PostTransactionQueryUpdate update;
            Map map;
            Transaction transaction;
            if (tm != null && tm.getStatus() == 0 && (transaction = tm.getTransaction()) != null && (map = (Map)this.transactionContext.get(transaction)) != null && (update = (PostTransactionQueryUpdate)map.get(key)) != null && (value = update.getValue()) != null) {
                return value;
            }
        }
        catch (SystemException e) {
            log.trace((Object)"Failed to retrieve current transaction status.", (Throwable)e);
        }
        if (skipCacheStore) {
            return this.getCache.withFlags(new Flag[]{Flag.SKIP_CACHE_STORE}).get(key);
        }
        return this.getCache.get(key);
    }

    public void put(Object key, Object value) throws CacheException {
        if (this.checkValid()) {
            TransactionManager tm = this.getTransactionManager();
            Transaction transaction = null;
            try {
                Transaction transaction2 = transaction = tm != null && tm.getStatus() == 0 ? tm.getTransaction() : null;
                if (transaction != null) {
                    PostTransactionQueryUpdate update;
                    ConcurrentHashMap<Object, PostTransactionQueryUpdate> map = (ConcurrentHashMap<Object, PostTransactionQueryUpdate>)this.transactionContext.get(transaction);
                    if (map == null) {
                        map = new ConcurrentHashMap<Object, PostTransactionQueryUpdate>();
                        this.transactionContext.put(transaction, map);
                    }
                    if ((update = (PostTransactionQueryUpdate)map.get(key)) == null) {
                        update = new PostTransactionQueryUpdate(transaction, key, value);
                        transaction.registerSynchronization((Synchronization)update);
                        map.put(key, update);
                    } else {
                        update.setValue(value);
                    }
                    return;
                }
            }
            catch (SystemException e) {
                log.trace((Object)e);
                return;
            }
            catch (RollbackException e) {
                log.error((Object)"Cannot register synchronization to rolled back transaction", (Throwable)e);
                return;
            }
            this.putCache.put(key, value);
        }
    }

    private class PostTransactionQueryUpdate
    implements Synchronization {
        private final Transaction transaction;
        private final Object key;
        private volatile Object value;

        public PostTransactionQueryUpdate(Transaction transaction, Object key, Object value) {
            this.transaction = transaction;
            this.key = key;
            this.value = value;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public void beforeCompletion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void afterCompletion(int status) {
            QueryResultsRegionImpl.this.transactionContext.remove(this.transaction);
            final Object value = this.value;
            if (value == null) {
                return;
            }
            switch (status) {
                case 3: 
                case 8: {
                    TransactionManager tm = QueryResultsRegionImpl.this.getTransactionManager();
                    Transaction suspended = null;
                    suspended = tm.suspend();
                    if (QueryResultsRegionImpl.this.putCacheRequiresTransaction) {
                        Caches.withinTx(tm, new Callable<Void>(){

                            @Override
                            public Void call() throws Exception {
                                QueryResultsRegionImpl.this.putCache.put(PostTransactionQueryUpdate.this.key, value);
                                return null;
                            }
                        });
                    } else {
                        QueryResultsRegionImpl.this.putCache.put(this.key, value);
                    }
                    if (suspended == null) break;
                    try {
                        tm.resume(suspended);
                    }
                    catch (Exception e) {
                        log.error((Object)("Failed to resume suspended transaction " + suspended), (Throwable)e);
                    }
                    break;
                    catch (Exception e) {
                        try {
                            if (log.isTraceEnabled()) {
                                log.trace((Object)"Exception during query cache update", (Throwable)e);
                            }
                            if (suspended == null) break;
                        }
                        catch (Throwable throwable) {
                            if (suspended != null) {
                                try {
                                    tm.resume(suspended);
                                }
                                catch (Exception e2) {
                                    log.error((Object)("Failed to resume suspended transaction " + suspended), (Throwable)e2);
                                }
                            }
                            throw throwable;
                        }
                        try {
                            tm.resume(suspended);
                        }
                        catch (Exception e3) {
                            log.error((Object)("Failed to resume suspended transaction " + suspended), (Throwable)e3);
                        }
                        break;
                    }
                }
            }
        }
    }
}

