/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.infinispan.access;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.hibernate.cache.CacheException;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.manager.EmbeddedCacheManager;

public class PutFromLoadValidator {
    public static final long NAKED_PUT_INVALIDATION_PERIOD = TimeUnit.SECONDS.toMillis(20L);
    private final TransactionManager transactionManager;
    private final long nakedPutInvalidationPeriod;
    private final ConcurrentMap<Object, PendingPutMap> pendingPuts;
    private final ConcurrentMap<Object, Long> recentRemovals = new ConcurrentHashMap<Object, Long>();
    private final List<RecentRemoval> removalsQueue = new LinkedList<RecentRemoval>();
    private volatile long earliestRemovalTimestamp;
    private final Lock removalsLock = new ReentrantLock();
    private volatile long invalidationTimestamp;
    private static final int GC_THRESHOLD = 10;
    private final long expirationTimeout;

    public PutFromLoadValidator(AdvancedCache cache) {
        this(cache, NAKED_PUT_INVALIDATION_PERIOD);
    }

    public PutFromLoadValidator(AdvancedCache cache, long nakedPutInvalidationPeriod) {
        this(cache.getCacheManager(), cache.getTransactionManager(), nakedPutInvalidationPeriod);
    }

    public PutFromLoadValidator(EmbeddedCacheManager cacheManager, TransactionManager tm, long nakedPutInvalidationPeriod) {
        Cache cache;
        this.pendingPuts = cache = cacheManager.getCache("pending-puts");
        this.expirationTimeout = cache.getCacheConfiguration().expiration().maxIdle();
        this.transactionManager = tm;
        this.nakedPutInvalidationPeriod = nakedPutInvalidationPeriod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean acquirePutFromLoadLock(Object key) {
        boolean valid;
        block12: {
            valid = false;
            boolean locked = false;
            long now = System.currentTimeMillis();
            try {
                Long removedTime;
                PendingPutMap pending = (PendingPutMap)this.pendingPuts.get(key);
                if (pending != null) {
                    locked = pending.acquireLock(100L, TimeUnit.MILLISECONDS);
                    if (!locked) break block12;
                    try {
                        PendingPut toCancel = pending.remove(this.getOwnerForPut());
                        if (toCancel != null) {
                            valid = !toCancel.completed;
                            toCancel.completed = true;
                        }
                        break block12;
                    }
                    finally {
                        if (!valid) {
                            pending.releaseLock();
                            locked = false;
                        }
                    }
                }
                if (now > this.invalidationTimestamp && ((removedTime = (Long)this.recentRemovals.get(key)) == null || now > removedTime)) {
                    this.registerPendingPut(key);
                    valid = locked = this.acquirePutFromLoadLock(key);
                }
            }
            catch (Throwable t) {
                PendingPutMap toRelease;
                if (locked && (toRelease = (PendingPutMap)this.pendingPuts.get(key)) != null) {
                    toRelease.releaseLock();
                }
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                if (t instanceof Error) {
                    throw (Error)t;
                }
                throw new RuntimeException(t);
            }
        }
        return valid;
    }

    public void releasePutFromLoadLock(Object key) {
        PendingPutMap pending = (PendingPutMap)this.pendingPuts.get(key);
        if (pending != null) {
            if (pending.size() == 0) {
                this.pendingPuts.remove(key, pending);
            }
            pending.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean invalidateKey(Object key) {
        Long cleaned;
        boolean success = true;
        PendingPutMap pending = (PendingPutMap)this.pendingPuts.get(key);
        if (pending != null) {
            if (pending.acquireLock(60L, TimeUnit.SECONDS)) {
                try {
                    pending.invalidate();
                }
                finally {
                    pending.releaseLock();
                }
            } else {
                success = false;
            }
        }
        RecentRemoval removal = new RecentRemoval(key, this.nakedPutInvalidationPeriod);
        this.recentRemovals.put(key, removal.timestamp);
        RecentRemoval toClean = null;
        boolean attemptClean = removal.timestamp > this.earliestRemovalTimestamp;
        this.removalsLock.lock();
        try {
            this.removalsQueue.add(removal);
            if (attemptClean) {
                if (this.removalsQueue.size() > 1) {
                    toClean = this.removalsQueue.remove(0);
                }
                this.earliestRemovalTimestamp = this.removalsQueue.get(0).timestamp;
            }
        }
        finally {
            this.removalsLock.unlock();
        }
        if (toClean != null && (cleaned = (Long)this.recentRemovals.get(toClean.key)) != null && cleaned.equals(toClean.timestamp) && (cleaned = (Long)this.recentRemovals.remove(toClean.key)) != null && !cleaned.equals(toClean.timestamp)) {
            this.recentRemovals.putIfAbsent(toClean.key, cleaned);
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean invalidateRegion() {
        boolean ok = false;
        this.invalidationTimestamp = System.currentTimeMillis() + this.nakedPutInvalidationPeriod;
        try {
            for (PendingPutMap entry : this.pendingPuts.values()) {
                if (entry.acquireLock(60L, TimeUnit.SECONDS)) {
                    try {
                        entry.invalidate();
                        continue;
                    }
                    finally {
                        entry.releaseLock();
                        continue;
                    }
                }
                ok = false;
            }
            this.removalsLock.lock();
            try {
                this.recentRemovals.clear();
                this.removalsQueue.clear();
                ok = true;
            }
            finally {
                this.removalsLock.unlock();
            }
        }
        catch (Exception e) {
            ok = false;
        }
        finally {
            this.earliestRemovalTimestamp = this.invalidationTimestamp;
        }
        return ok;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerPendingPut(Object key) {
        PendingPutMap existing;
        PendingPut pendingPut = new PendingPut(this.getOwnerForPut());
        PendingPutMap pendingForKey = new PendingPutMap(pendingPut);
        while ((existing = this.pendingPuts.putIfAbsent(key, pendingForKey)) != null && existing.acquireLock(10L, TimeUnit.SECONDS)) {
            try {
                existing.put(pendingPut);
                PendingPutMap doublecheck = this.pendingPuts.putIfAbsent(key, existing);
                if (doublecheck != null && doublecheck != existing) continue;
                break;
            }
            finally {
                existing.releaseLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getRemovalQueueLength() {
        this.removalsLock.lock();
        try {
            int n = this.removalsQueue.size();
            return n;
        }
        finally {
            this.removalsLock.unlock();
        }
    }

    private Object getOwnerForPut() {
        Transaction tx = null;
        try {
            if (this.transactionManager != null) {
                tx = this.transactionManager.getTransaction();
            }
        }
        catch (SystemException se) {
            throw new CacheException("Could not obtain transaction", (Throwable)se);
        }
        return tx == null ? Thread.currentThread() : tx;
    }

    private static class RecentRemoval {
        private final Object key;
        private final Long timestamp;

        private RecentRemoval(Object key, long nakedPutInvalidationPeriod) {
            this.key = key;
            this.timestamp = System.currentTimeMillis() + nakedPutInvalidationPeriod;
        }
    }

    private static class PendingPut {
        private final Object owner;
        private volatile boolean completed;
        private long timestamp = Long.MIN_VALUE;

        private PendingPut(Object owner) {
            this.owner = owner;
        }
    }

    private class PendingPutMap {
        private PendingPut singlePendingPut;
        private Map<Object, PendingPut> fullMap;
        private final Lock lock = new ReentrantLock();

        PendingPutMap(PendingPut singleItem) {
            this.singlePendingPut = singleItem;
        }

        public void put(PendingPut pendingPut) {
            if (this.singlePendingPut == null) {
                if (this.fullMap == null) {
                    this.singlePendingPut = pendingPut;
                } else {
                    this.fullMap.put(pendingPut.owner, pendingPut);
                    if (this.fullMap.size() > 10) {
                        long now = System.currentTimeMillis();
                        Iterator<PendingPut> iterator = this.fullMap.values().iterator();
                        while (iterator.hasNext()) {
                            PendingPut pp = iterator.next();
                            if (pp.timestamp == Long.MIN_VALUE) {
                                pp.timestamp = now;
                                continue;
                            }
                            if (now - pp.timestamp < PutFromLoadValidator.this.expirationTimeout) continue;
                            iterator.remove();
                        }
                    }
                }
            } else {
                this.fullMap = new HashMap<Object, PendingPut>(4);
                this.fullMap.put(this.singlePendingPut.owner, this.singlePendingPut);
                this.singlePendingPut = null;
                this.fullMap.put(pendingPut.owner, pendingPut);
            }
        }

        public PendingPut remove(Object ownerForPut) {
            PendingPut removed = null;
            if (this.fullMap == null) {
                if (this.singlePendingPut != null && this.singlePendingPut.owner.equals(ownerForPut)) {
                    removed = this.singlePendingPut;
                    this.singlePendingPut = null;
                }
            } else {
                removed = this.fullMap.remove(ownerForPut);
            }
            return removed;
        }

        public int size() {
            return this.fullMap == null ? (this.singlePendingPut == null ? 0 : 1) : this.fullMap.size();
        }

        public boolean acquireLock(long time, TimeUnit unit) {
            try {
                return this.lock.tryLock(time, unit);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return false;
            }
        }

        public void releaseLock() {
            this.lock.unlock();
        }

        public void invalidate() {
            if (this.singlePendingPut != null) {
                this.singlePendingPut.completed = true;
                this.singlePendingPut = null;
            } else if (this.fullMap != null) {
                for (PendingPut pp : this.fullMap.values()) {
                    pp.completed = true;
                }
                this.fullMap = null;
            }
        }
    }
}

