/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.test.cache.infinispan.util;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.hibernate.cache.infinispan.InfinispanRegionFactory;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.Settings;
import org.hibernate.internal.util.compare.EqualsHelper;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.test.cache.infinispan.util.BatchModeJtaPlatform;
import org.hibernate.test.cache.infinispan.util.CacheTestSupport;

public class CacheTestUtil {
    public static Configuration buildConfiguration(String regionPrefix, Class regionFactory, boolean use2ndLevel, boolean useQueries) {
        Configuration cfg = new Configuration();
        cfg.setProperty("hibernate.generate_statistics", "true");
        cfg.setProperty("hibernate.cache.use_structured_entries", "true");
        cfg.setProperty("hibernate.transaction.jta.platform", BatchModeJtaPlatform.class.getName());
        cfg.setProperty("hibernate.cache.region.factory_class", regionFactory.getName());
        cfg.setProperty("hibernate.cache.region_prefix", regionPrefix);
        cfg.setProperty("hibernate.cache.use_second_level_cache", String.valueOf(use2ndLevel));
        cfg.setProperty("hibernate.cache.use_query_cache", String.valueOf(useQueries));
        return cfg;
    }

    public static Configuration buildLocalOnlyConfiguration(String regionPrefix, boolean use2ndLevel, boolean useQueries) {
        Configuration cfg = CacheTestUtil.buildConfiguration(regionPrefix, InfinispanRegionFactory.class, use2ndLevel, useQueries);
        cfg.setProperty("hibernate.cache.infinispan.cfg", "org/hibernate/cache/infinispan/builder/infinispan-configs.xml");
        return cfg;
    }

    public static Configuration buildCustomQueryCacheConfiguration(String regionPrefix, String queryCacheName) {
        Configuration cfg = CacheTestUtil.buildConfiguration(regionPrefix, InfinispanRegionFactory.class, true, true);
        cfg.setProperty("hibernate.cache.infinispan.query.cfg", queryCacheName);
        return cfg;
    }

    public static InfinispanRegionFactory startRegionFactory(ServiceRegistry serviceRegistry, Configuration cfg) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Settings settings = cfg.buildSettings(serviceRegistry);
        Properties properties = cfg.getProperties();
        String factoryType = cfg.getProperty("hibernate.cache.region.factory_class");
        Class<?> factoryClass = Thread.currentThread().getContextClassLoader().loadClass(factoryType);
        InfinispanRegionFactory regionFactory = (InfinispanRegionFactory)factoryClass.newInstance();
        regionFactory.start(settings, properties);
        return regionFactory;
    }

    public static InfinispanRegionFactory startRegionFactory(ServiceRegistry serviceRegistry, Configuration cfg, CacheTestSupport testSupport) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        InfinispanRegionFactory factory = CacheTestUtil.startRegionFactory(serviceRegistry, cfg);
        testSupport.registerFactory((RegionFactory)factory);
        return factory;
    }

    public static void stopRegionFactory(InfinispanRegionFactory factory, CacheTestSupport testSupport) {
        factory.stop();
        testSupport.unregisterFactory((RegionFactory)factory);
    }

    public static TestSuite createFailureExpectedSuite(Class testClass) {
        TestSuite allTests = new TestSuite(testClass);
        HashSet<String> failureExpected = new HashSet<String>();
        Enumeration tests = allTests.tests();
        while (tests.hasMoreElements()) {
            String name;
            Test t = (Test)tests.nextElement();
            if (!(t instanceof TestCase) || !(name = ((TestCase)t).getName()).endsWith("FailureExpected")) continue;
            failureExpected.add(name);
        }
        TestSuite result = new TestSuite();
        tests = allTests.tests();
        while (tests.hasMoreElements()) {
            String name;
            Test t = (Test)tests.nextElement();
            if (!(t instanceof TestCase) || failureExpected.contains((name = ((TestCase)t).getName()) + "FailureExpected")) continue;
            result.addTest(t);
        }
        return result;
    }

    public static <T> void assertEqualsEventually(T expected, Callable<T> callable) throws Exception {
        CacheTestUtil.assertEqualsEventually(expected, callable, -1L, TimeUnit.SECONDS);
    }

    public static <T> void assertEqualsEventually(T expected, Callable<T> callable, long timeout, TimeUnit timeUnit) throws Exception {
        long deadline;
        long l = deadline = timeout <= 0L ? Long.MAX_VALUE : System.currentTimeMillis() + timeUnit.toMillis(timeout);
        while (true) {
            T value;
            if (EqualsHelper.equals(value = callable.call(), expected)) {
                return;
            }
            long now = System.currentTimeMillis();
            if (now >= deadline) break;
            Thread.sleep(Math.min(100L, deadline - now));
        }
        throw new TimeoutException();
    }

    private CacheTestUtil() {
    }
}

