/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.test.cache.infinispan.functional.cluster;

import org.hibernate.cfg.Configuration;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.transaction.internal.jta.CMTTransactionFactory;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.internal.StandardServiceRegistryImpl;
import org.hibernate.test.cache.infinispan.functional.cluster.ClusterAwareRegionFactory;
import org.hibernate.test.cache.infinispan.functional.cluster.DualNodeConnectionProviderImpl;
import org.hibernate.test.cache.infinispan.functional.cluster.DualNodeJtaPlatformImpl;
import org.hibernate.test.cache.infinispan.functional.cluster.DualNodeJtaTransactionManagerImpl;
import org.hibernate.testing.junit4.BaseCoreFunctionalTestCase;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.junit.After;
import org.junit.Before;

public abstract class DualNodeTestCase
extends BaseCoreFunctionalTestCase {
    private static final Log log = LogFactory.getLog(DualNodeTestCase.class);
    public static final String NODE_ID_PROP = "hibernate.test.cluster.node.id";
    public static final String NODE_ID_FIELD = "nodeId";
    public static final String LOCAL = "local";
    public static final String REMOTE = "remote";
    private SecondNodeEnvironment secondNodeEnvironment;

    public String[] getMappings() {
        return new String[]{"cache/infinispan/functional/Contact.hbm.xml", "cache/infinispan/functional/Customer.hbm.xml"};
    }

    public String getCacheConcurrencyStrategy() {
        return "transactional";
    }

    public void configure(Configuration cfg) {
        this.standardConfigure(cfg);
        cfg.setProperty(NODE_ID_PROP, LOCAL);
        cfg.setProperty(NODE_ID_FIELD, LOCAL);
    }

    protected void cleanupTest() throws Exception {
        this.cleanupTransactionManagement();
    }

    protected void cleanupTransactionManagement() {
        DualNodeJtaTransactionManagerImpl.cleanupTransactions();
        DualNodeJtaTransactionManagerImpl.cleanupTransactionManagers();
    }

    @Before
    public void prepare() throws Exception {
        this.secondNodeEnvironment = new SecondNodeEnvironment();
    }

    @After
    public void unPrepare() {
        if (this.secondNodeEnvironment != null) {
            this.secondNodeEnvironment.shutDown();
        }
    }

    protected SecondNodeEnvironment secondNodeEnvironment() {
        return this.secondNodeEnvironment;
    }

    protected Class getCacheRegionFactory() {
        return ClusterAwareRegionFactory.class;
    }

    protected Class getConnectionProviderClass() {
        return DualNodeConnectionProviderImpl.class;
    }

    protected Class getJtaPlatformClass() {
        return DualNodeJtaPlatformImpl.class;
    }

    protected Class getTransactionFactoryClass() {
        return CMTTransactionFactory.class;
    }

    protected void sleep(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            log.warn((Object)"Interrupted during sleep", (Throwable)e);
        }
    }

    protected boolean getUseQueryCache() {
        return true;
    }

    protected void configureSecondNode(Configuration cfg) {
    }

    protected void standardConfigure(Configuration cfg) {
        super.configure(cfg);
        cfg.setProperty("hibernate.connection.provider_class", this.getConnectionProviderClass().getName());
        cfg.setProperty("hibernate.transaction.jta.platform", this.getJtaPlatformClass().getName());
        cfg.setProperty("hibernate.transaction.factory_class", this.getTransactionFactoryClass().getName());
        cfg.setProperty("hibernate.cache.region.factory_class", this.getCacheRegionFactory().getName());
        cfg.setProperty("hibernate.cache.use_query_cache", String.valueOf(this.getUseQueryCache()));
    }

    public class SecondNodeEnvironment {
        private Configuration configuration;
        private StandardServiceRegistryImpl serviceRegistry;
        private SessionFactoryImplementor sessionFactory;

        public SecondNodeEnvironment() {
            this.configuration = DualNodeTestCase.this.constructConfiguration();
            DualNodeTestCase.this.standardConfigure(this.configuration);
            this.configuration.setProperty(DualNodeTestCase.NODE_ID_PROP, DualNodeTestCase.REMOTE);
            this.configuration.setProperty(DualNodeTestCase.NODE_ID_FIELD, DualNodeTestCase.REMOTE);
            DualNodeTestCase.this.configureSecondNode(this.configuration);
            DualNodeTestCase.this.addMappings(this.configuration);
            this.configuration.buildMappings();
            DualNodeTestCase.this.applyCacheSettings(this.configuration);
            DualNodeTestCase.this.afterConfigurationBuilt(this.configuration);
            this.serviceRegistry = DualNodeTestCase.this.buildServiceRegistry(this.configuration);
            this.sessionFactory = (SessionFactoryImplementor)this.configuration.buildSessionFactory((ServiceRegistry)this.serviceRegistry);
        }

        public Configuration getConfiguration() {
            return this.configuration;
        }

        public StandardServiceRegistryImpl getServiceRegistry() {
            return this.serviceRegistry;
        }

        public SessionFactoryImplementor getSessionFactory() {
            return this.sessionFactory;
        }

        public void shutDown() {
            if (this.sessionFactory != null) {
                try {
                    this.sessionFactory.close();
                }
                catch (Exception ignore) {
                    // empty catch block
                }
            }
            if (this.serviceRegistry != null) {
                try {
                    this.serviceRegistry.destroy();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

