/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.test.cache.infinispan.collection;

import org.hibernate.cache.infinispan.InfinispanRegionFactory;
import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.cache.spi.access.CollectionRegionAccessStrategy;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.cfg.Configuration;
import org.hibernate.test.cache.infinispan.AbstractNonFunctionalTestCase;
import org.hibernate.test.cache.infinispan.NodeEnvironment;
import org.hibernate.test.cache.infinispan.util.CacheTestUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TransactionalExtraAPITestCase
extends AbstractNonFunctionalTestCase {
    public static final String REGION_NAME = "test/com.foo.test";
    public static final String KEY = "KEY";
    public static final String VALUE1 = "VALUE1";
    public static final String VALUE2 = "VALUE2";
    private NodeEnvironment environment;
    private static CollectionRegionAccessStrategy accessStrategy;

    @Before
    public final void prepareLocalAccessStrategy() throws Exception {
        this.environment = new NodeEnvironment(this.createConfiguration());
        this.environment.prepare();
        this.avoidConcurrentFlush();
        accessStrategy = this.environment.getCollectionRegion(REGION_NAME, null).buildAccessStrategy(this.getAccessType());
    }

    protected Configuration createConfiguration() {
        Configuration cfg = CacheTestUtil.buildConfiguration("test", InfinispanRegionFactory.class, true, false);
        cfg.setProperty("hibernate.cache.infinispan.entity.cfg", this.getCacheConfigName());
        return cfg;
    }

    protected String getCacheConfigName() {
        return "entity";
    }

    protected AccessType getAccessType() {
        return AccessType.TRANSACTIONAL;
    }

    @After
    public final void releaseLocalAccessStrategy() throws Exception {
        if (this.environment != null) {
            this.environment.release();
        }
    }

    protected CollectionRegionAccessStrategy getCollectionAccessStrategy() {
        return accessStrategy;
    }

    @Test
    public void testLockItem() {
        Assert.assertNull((Object)this.getCollectionAccessStrategy().lockItem((Object)KEY, (Object)new Integer(1)));
    }

    @Test
    public void testLockRegion() {
        Assert.assertNull((Object)this.getCollectionAccessStrategy().lockRegion());
    }

    @Test
    public void testUnlockItem() {
        this.getCollectionAccessStrategy().unlockItem((Object)KEY, (SoftLock)new MockSoftLock());
    }

    @Test
    public void testUnlockRegion() {
        this.getCollectionAccessStrategy().unlockItem((Object)KEY, (SoftLock)new MockSoftLock());
    }

    public static class MockSoftLock
    implements SoftLock {
    }
}

