/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.test.cache.infinispan.functional.cluster;

import java.util.Map;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.hibernate.HibernateException;
import org.hibernate.TransactionException;
import org.hibernate.engine.transaction.internal.jta.JtaStatusHelper;
import org.hibernate.service.jta.platform.spi.JtaPlatform;
import org.hibernate.service.spi.Configurable;
import org.hibernate.test.cache.infinispan.functional.cluster.DualNodeJtaTransactionManagerImpl;

public class DualNodeJtaPlatformImpl
implements JtaPlatform,
Configurable {
    private String nodeId;

    public void configure(Map configurationValues) {
        this.nodeId = (String)configurationValues.get("hibernate.test.cluster.node.id");
        if (this.nodeId == null) {
            throw new HibernateException("hibernate.test.cluster.node.id not configured");
        }
    }

    public TransactionManager retrieveTransactionManager() {
        return DualNodeJtaTransactionManagerImpl.getInstance(this.nodeId);
    }

    public UserTransaction retrieveUserTransaction() {
        throw new TransactionException("UserTransaction not used in these tests");
    }

    public Object getTransactionIdentifier(Transaction transaction) {
        return transaction;
    }

    public boolean canRegisterSynchronization() {
        return JtaStatusHelper.isActive((TransactionManager)this.retrieveTransactionManager());
    }

    public void registerSynchronization(Synchronization synchronization) {
        try {
            this.retrieveTransactionManager().getTransaction().registerSynchronization(synchronization);
        }
        catch (Exception e) {
            throw new TransactionException("Could not obtain transaction from TM");
        }
    }

    public int getCurrentStatus() throws SystemException {
        return JtaStatusHelper.getStatus((TransactionManager)this.retrieveTransactionManager());
    }
}

