/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.test.cache.infinispan.functional.cluster;

import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.test.cache.infinispan.functional.classloader.Account;
import org.hibernate.test.cache.infinispan.functional.classloader.ClassLoaderTestDAO;
import org.hibernate.test.cache.infinispan.functional.cluster.ClusterAwareRegionFactory;
import org.hibernate.test.cache.infinispan.functional.cluster.DualNodeJtaTransactionManagerImpl;
import org.hibernate.test.cache.infinispan.functional.cluster.DualNodeTestCase;
import org.infinispan.Cache;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.TestingUtil;
import org.jboss.logging.Logger;
import org.junit.Assert;
import org.junit.Test;

public class SessionRefreshTestCase
extends DualNodeTestCase {
    private static final Logger log = Logger.getLogger(SessionRefreshTestCase.class);
    static int test = 0;
    private Cache localCache;

    @Override
    protected void configureSecondNode(Configuration cfg) {
        super.configureSecondNode(cfg);
        cfg.setProperty("hibernate.cache.use_second_level_cache", "false");
    }

    @Override
    protected void standardConfigure(Configuration cfg) {
        super.standardConfigure(cfg);
        cfg.setProperty("hibernate.cache.infinispan.entity.cfg", this.getEntityCacheConfigName());
    }

    protected String getEntityCacheConfigName() {
        return "entity";
    }

    @Override
    public String[] getMappings() {
        return new String[]{"cache/infinispan/functional/classloader/Account.hbm.xml"};
    }

    @Override
    protected void cleanupTransactionManagement() {
        DualNodeJtaTransactionManagerImpl.cleanupTransactions();
    }

    @Test
    public void testRefreshAfterExternalChange() throws Exception {
        EmbeddedCacheManager localManager = ClusterAwareRegionFactory.getCacheManager("local");
        this.localCache = localManager.getCache(Account.class.getName());
        DualNodeJtaTransactionManagerImpl localTM = DualNodeJtaTransactionManagerImpl.getInstance("local");
        SessionFactoryImplementor localFactory = this.sessionFactory();
        DualNodeJtaTransactionManagerImpl remoteTM = DualNodeJtaTransactionManagerImpl.getInstance("remote");
        SessionFactoryImplementor remoteFactory = this.secondNodeEnvironment().getSessionFactory();
        ClassLoaderTestDAO dao0 = new ClassLoaderTestDAO((SessionFactory)localFactory, localTM);
        ClassLoaderTestDAO dao1 = new ClassLoaderTestDAO((SessionFactory)remoteFactory, remoteTM);
        Integer id = new Integer(1);
        dao0.createAccount(dao0.getSmith(), id, new Integer(5), "local");
        Account acct1 = dao1.getAccount(id);
        Assert.assertNotNull((Object)acct1);
        Assert.assertEquals((Object)"local", (Object)acct1.getBranch());
        dao1.updateAccountBranch(id, "remote");
        Account acct0 = dao0.getAccount(id);
        Assert.assertNotNull((Object)acct0);
        Assert.assertEquals((Object)"local", (Object)acct0.getBranch());
        log.debug((Object)("Contents when re-reading from local: " + TestingUtil.printCache((Cache)this.localCache)));
        acct0 = dao0.getAccountWithRefresh(id);
        Assert.assertNotNull((Object)acct0);
        Assert.assertEquals((Object)"remote", (Object)acct0.getBranch());
        log.debug((Object)("Contents after refreshing in remote: " + TestingUtil.printCache((Cache)this.localCache)));
        ClassLoaderTestDAO dao0A = new ClassLoaderTestDAO((SessionFactory)localFactory, localTM);
        Account acct0A = dao0A.getAccount(id);
        Assert.assertNotNull((Object)acct0A);
        Assert.assertEquals((Object)"remote", (Object)acct0A.getBranch());
        log.debug((Object)("Contents after creating a new session: " + TestingUtil.printCache((Cache)this.localCache)));
    }
}

