/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.test.cache.infinispan.stress.entities;

import java.util.HashSet;
import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import org.hibernate.test.cache.infinispan.stress.entities.Person;

@Entity
public final class Family {
    @Id
    @GeneratedValue
    private int id;
    private String name;
    private String secondName;
    @OneToMany
    private Set<Person> members;
    private int version;

    public Family(String name) {
        this.name = name;
        this.secondName = null;
        this.members = new HashSet<Person>();
        this.id = 0;
        this.version = 0;
    }

    protected Family() {
        this.name = null;
        this.secondName = null;
        this.members = new HashSet<Person>();
        this.id = 0;
        this.version = 0;
    }

    public String getName() {
        return this.name;
    }

    public Set<Person> getMembers() {
        return this.members;
    }

    public String getSecondName() {
        return this.secondName;
    }

    public void setSecondName(String secondName) {
        this.secondName = secondName;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getVersion() {
        return this.version;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setMembers(Set<Person> members) {
        this.members = members == null ? new HashSet<Person>() : members;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    boolean addMember(Person member) {
        return this.members.add(member);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Family family = (Family)o;
        if (this.id != family.id) {
            return false;
        }
        if (this.version != family.version) {
            return false;
        }
        if (this.members != null ? !this.members.equals(family.members) : family.members != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(family.name) : family.name != null) {
            return false;
        }
        return !(this.secondName != null ? !this.secondName.equals(family.secondName) : family.secondName != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.secondName != null ? this.secondName.hashCode() : 0);
        result = 31 * result + (this.members != null ? this.members.hashCode() : 0);
        result = 31 * result + this.id;
        result = 31 * result + this.version;
        return result;
    }

    public String toString() {
        return "Family{id=" + this.id + ", name='" + this.name + '\'' + ", secondName='" + this.secondName + '\'' + ", members=" + this.members + ", version=" + this.version + '}';
    }
}

