/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.infinispan.access;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hibernate.cache.infinispan.access.BaseInvalidationInterceptor;
import org.hibernate.cache.infinispan.util.InfinispanMessageLogger;
import org.infinispan.commands.AbstractVisitor;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.InvalidateCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.util.InfinispanCollections;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.LocalTxInvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.remoting.transport.Address;

@MBean(objectName="Invalidation", description="Component responsible for invalidating entries on remote caches when entries are written to locally.")
public class TxInvalidationInterceptor
extends BaseInvalidationInterceptor {
    private static final InfinispanMessageLogger log = InfinispanMessageLogger.Provider.getLog(TxInvalidationInterceptor.class);

    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        if (!this.isPutForExternalRead((FlagAffectedCommand)command)) {
            return this.handleInvalidate(ctx, (WriteCommand)command, command.getKey());
        }
        return this.invokeNextInterceptor(ctx, (VisitableCommand)command);
    }

    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        return this.handleInvalidate(ctx, (WriteCommand)command, command.getKey());
    }

    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        return this.handleInvalidate(ctx, (WriteCommand)command, command.getKey());
    }

    public Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
        Object retval = this.invokeNextInterceptor(ctx, (VisitableCommand)command);
        if (!this.isLocalModeForced((FlagAffectedCommand)command) && ctx.isOriginLocal()) {
            this.rpcManager.invokeRemotely(this.getMembers(), (ReplicableCommand)command, this.isSynchronous((FlagAffectedCommand)command) ? this.syncRpcOptions : this.asyncRpcOptions);
        }
        return retval;
    }

    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        return this.handleInvalidate(ctx, (WriteCommand)command, command.getMap().keySet().toArray());
    }

    public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        Object retval = this.invokeNextInterceptor((InvocationContext)ctx, (VisitableCommand)command);
        log.tracef("Entering InvalidationInterceptor's prepare phase.  Ctx flags are empty", new Object[0]);
        if (this.shouldInvokeRemoteTxCommand(ctx)) {
            if (ctx.getTransaction() == null) {
                throw new IllegalStateException("We must have an associated transaction");
            }
            List<WriteCommand> mods = Arrays.asList(command.getModifications());
            this.broadcastInvalidateForPrepare(mods, (InvocationContext)ctx);
        } else {
            log.tracef("Nothing to invalidate - no modifications in the transaction.", new Object[0]);
        }
        return retval;
    }

    public Object visitLockControlCommand(TxInvocationContext ctx, LockControlCommand command) throws Throwable {
        Object retVal = this.invokeNextInterceptor((InvocationContext)ctx, (VisitableCommand)command);
        if (ctx.isOriginLocal()) {
            boolean sync = !command.isUnlock();
            List<Address> members = this.getMembers();
            ((LocalTxInvocationContext)ctx).remoteLocksAcquired(members);
            this.rpcManager.invokeRemotely(members, (ReplicableCommand)command, sync ? this.syncRpcOptions : this.asyncRpcOptions);
        }
        return retVal;
    }

    private Object handleInvalidate(InvocationContext ctx, WriteCommand command, Object ... keys) throws Throwable {
        Object retval = this.invokeNextInterceptor(ctx, (VisitableCommand)command);
        if (command.isSuccessful() && !ctx.isInTxScope() && keys != null && keys.length != 0 && !this.isLocalModeForced((FlagAffectedCommand)command)) {
            this.invalidateAcrossCluster(this.isSynchronous((FlagAffectedCommand)command), keys, ctx);
        }
        return retval;
    }

    private void broadcastInvalidateForPrepare(List<WriteCommand> modifications, InvocationContext ctx) throws Throwable {
        if (ctx.isInTxScope()) {
            if (modifications.isEmpty()) {
                return;
            }
            InvalidationFilterVisitor filterVisitor = new InvalidationFilterVisitor(modifications.size());
            filterVisitor.visitCollection(null, modifications);
            if (filterVisitor.containsPutForExternalRead) {
                log.debug("Modification list contains a putForExternalRead operation.  Not invalidating.");
            } else if (filterVisitor.containsLocalModeFlag) {
                log.debug("Modification list contains a local mode flagged operation.  Not invalidating.");
            } else {
                try {
                    this.invalidateAcrossCluster(this.defaultSynchronous, filterVisitor.result.toArray(), ctx);
                }
                catch (Throwable t) {
                    log.unableToRollbackInvalidationsDuringPrepare(t);
                    if (t instanceof RuntimeException) {
                        throw t;
                    }
                    throw new RuntimeException("Unable to broadcast invalidation messages", t);
                }
            }
        }
    }

    private void invalidateAcrossCluster(boolean synchronous, Object[] keys, InvocationContext ctx) throws Throwable {
        this.incrementInvalidations();
        InvalidateCommand invalidateCommand = this.commandsFactory.buildInvalidateCommand(InfinispanCollections.emptySet(), keys);
        if (log.isDebugEnabled()) {
            log.debug("Cache [" + this.rpcManager.getAddress() + "] replicating " + invalidateCommand);
        }
        InvalidateCommand command = invalidateCommand;
        if (ctx.isInTxScope()) {
            TxInvocationContext txCtx = (TxInvocationContext)ctx;
            command = this.commandsFactory.buildPrepareCommand(txCtx.getGlobalTransaction(), Collections.singletonList(invalidateCommand), true);
        }
        this.rpcManager.invokeRemotely(this.getMembers(), (ReplicableCommand)command, synchronous ? this.syncRpcOptions : this.asyncRpcOptions);
    }

    public static class InvalidationFilterVisitor
    extends AbstractVisitor {
        Set<Object> result;
        public boolean containsPutForExternalRead = false;
        public boolean containsLocalModeFlag = false;

        public InvalidationFilterVisitor(int maxSetSize) {
            this.result = new HashSet<Object>(maxSetSize);
        }

        private void processCommand(FlagAffectedCommand command) {
            this.containsLocalModeFlag = this.containsLocalModeFlag || command.getFlags() != null && command.getFlags().contains(Flag.CACHE_MODE_LOCAL);
        }

        public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
            this.processCommand((FlagAffectedCommand)command);
            this.containsPutForExternalRead = this.containsPutForExternalRead || command.getFlags() != null && command.getFlags().contains(Flag.PUT_FOR_EXTERNAL_READ);
            this.result.add(command.getKey());
            return null;
        }

        public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
            this.processCommand((FlagAffectedCommand)command);
            this.result.add(command.getKey());
            return null;
        }

        public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
            this.processCommand((FlagAffectedCommand)command);
            this.result.addAll(command.getAffectedKeys());
            return null;
        }
    }
}

