/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpamodelgen.annotation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.tools.Diagnostic;
import org.hibernate.jpamodelgen.Context;
import org.hibernate.jpamodelgen.ImportContextImpl;
import org.hibernate.jpamodelgen.annotation.AnnotationMetaAttribute;
import org.hibernate.jpamodelgen.annotation.MetaAttributeGenerationVisitor;
import org.hibernate.jpamodelgen.model.ImportContext;
import org.hibernate.jpamodelgen.model.MetaAttribute;
import org.hibernate.jpamodelgen.model.MetaEntity;
import org.hibernate.jpamodelgen.util.AccessType;
import org.hibernate.jpamodelgen.util.AccessTypeInformation;
import org.hibernate.jpamodelgen.util.TypeUtils;

public class AnnotationMetaEntity
implements MetaEntity {
    private final ImportContext importContext;
    private final TypeElement element;
    private final Map<String, MetaAttribute> members;
    private final Context context;
    private AccessTypeInformation entityAccessTypeInfo;
    private boolean initialized;
    private MetaEntity entityToMerge;

    public AnnotationMetaEntity(TypeElement element, Context context, boolean lazilyInitialised) {
        this.element = element;
        this.context = context;
        this.members = new HashMap<String, MetaAttribute>();
        this.importContext = new ImportContextImpl(this.getPackageName());
        if (!lazilyInitialised) {
            this.init();
        }
    }

    public AccessTypeInformation getEntityAccessTypeInfo() {
        return this.entityAccessTypeInfo;
    }

    public final Context getContext() {
        return this.context;
    }

    @Override
    public final String getSimpleName() {
        return this.element.getSimpleName().toString();
    }

    @Override
    public final String getQualifiedName() {
        return this.element.getQualifiedName().toString();
    }

    @Override
    public final String getPackageName() {
        PackageElement packageOf = this.context.getElementUtils().getPackageOf(this.element);
        return this.context.getElementUtils().getName(packageOf.getQualifiedName()).toString();
    }

    @Override
    public List<MetaAttribute> getMembers() {
        if (!this.initialized) {
            this.init();
            if (this.entityToMerge != null) {
                this.mergeInMembers(this.entityToMerge.getMembers());
            }
        }
        return new ArrayList<MetaAttribute>(this.members.values());
    }

    @Override
    public boolean isMetaComplete() {
        return false;
    }

    private void mergeInMembers(Collection<MetaAttribute> attributes) {
        for (MetaAttribute attribute : attributes) {
            this.importType(attribute.getMetaType());
            this.importType(attribute.getTypeDeclaration());
            this.members.put(attribute.getPropertyName(), attribute);
        }
    }

    public void mergeInMembers(MetaEntity other) {
        if (!this.initialized) {
            this.entityToMerge = other;
        } else {
            this.mergeInMembers(other.getMembers());
        }
    }

    @Override
    public final String generateImports() {
        return this.importContext.generateImports();
    }

    @Override
    public final String importType(String fqcn) {
        return this.importContext.importType(fqcn);
    }

    @Override
    public final String staticImport(String fqcn, String member) {
        return this.importContext.staticImport(fqcn, member);
    }

    @Override
    public final TypeElement getTypeElement() {
        return this.element;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("AnnotationMetaEntity");
        sb.append("{element=").append(this.element);
        sb.append(", members=").append(this.members);
        sb.append('}');
        return sb.toString();
    }

    protected TypeElement getElement() {
        return this.element;
    }

    protected final void init() {
        this.getContext().logMessage(Diagnostic.Kind.OTHER, "Initializing type " + this.getQualifiedName() + ".");
        TypeUtils.determineAccessTypeForHierarchy(this.element, this.context);
        this.entityAccessTypeInfo = this.context.getAccessTypeInfo(this.getQualifiedName());
        List<VariableElement> fieldsOfClass = ElementFilter.fieldsIn(this.element.getEnclosedElements());
        this.addPersistentMembers(fieldsOfClass, AccessType.FIELD);
        List<ExecutableElement> methodsOfClass = ElementFilter.methodsIn(this.element.getEnclosedElements());
        ArrayList<Element> gettersAndSettersOfClass = new ArrayList<Element>();
        for (Element element : methodsOfClass) {
            if (!this.isGetterOrSetter(element)) continue;
            gettersAndSettersOfClass.add(element);
        }
        this.addPersistentMembers(gettersAndSettersOfClass, AccessType.PROPERTY);
        this.initialized = true;
    }

    private boolean isGetterOrSetter(Element methodOfClass) {
        ExecutableType methodType = (ExecutableType)methodOfClass.asType();
        String methodSimpleName = methodOfClass.getSimpleName().toString();
        List<? extends TypeMirror> methodParameterTypes = methodType.getParameterTypes();
        TypeMirror returnType = methodType.getReturnType();
        if (methodSimpleName.startsWith("set") && methodParameterTypes.size() == 1 && "void".equalsIgnoreCase(returnType.toString())) {
            return true;
        }
        return (methodSimpleName.startsWith("get") || methodSimpleName.startsWith("is")) && methodParameterTypes.isEmpty() && !"void".equalsIgnoreCase(returnType.toString());
    }

    private void addPersistentMembers(List<? extends Element> membersOfClass, AccessType membersKind) {
        for (Element element : membersOfClass) {
            AccessType forcedAccessType = TypeUtils.determineAnnotationSpecifiedAccessType(element);
            if (this.entityAccessTypeInfo.getAccessType() != membersKind && forcedAccessType == null || TypeUtils.containsAnnotation(element, "javax.persistence.Transient") || element.getModifiers().contains((Object)Modifier.TRANSIENT) || element.getModifiers().contains((Object)Modifier.STATIC)) continue;
            MetaAttributeGenerationVisitor visitor = new MetaAttributeGenerationVisitor(this, this.context);
            AnnotationMetaAttribute result = element.asType().accept(visitor, element);
            if (result == null) continue;
            this.members.put(result.getPropertyName(), result);
        }
    }
}

