/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc.env.internal;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.hibernate.HibernateException;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.env.spi.SchemaNameResolver;
import org.jboss.logging.Logger;

public class DefaultSchemaNameResolver
implements SchemaNameResolver {
    private static final Logger log = Logger.getLogger(DefaultSchemaNameResolver.class);
    public static final DefaultSchemaNameResolver INSTANCE = new DefaultSchemaNameResolver();
    private SchemaNameResolver delegate;

    private DefaultSchemaNameResolver() {
    }

    private void determineAppropriateResolverDelegate(Connection connection) {
        if (this.delegate == null) {
            try {
                Class<?> jdbcConnectionClass = connection.getClass();
                Method getSchemaMethod = jdbcConnectionClass.getMethod("getSchema", new Class[0]);
                if (getSchemaMethod != null && getSchemaMethod.getReturnType().equals(String.class)) {
                    try {
                        this.delegate = new SchemaNameResolverJava17Delegate(getSchemaMethod);
                        this.delegate.resolveSchemaName(connection, null);
                    }
                    catch (AbstractMethodError e) {
                        log.debugf("Unable to use Java 1.7 Connection#getSchema", new Object[0]);
                        this.delegate = SchemaNameResolverFallbackDelegate.INSTANCE;
                    }
                } else {
                    log.debugf("Unable to use Java 1.7 Connection#getSchema", new Object[0]);
                    this.delegate = SchemaNameResolverFallbackDelegate.INSTANCE;
                }
            }
            catch (Exception ignore) {
                this.delegate = SchemaNameResolverFallbackDelegate.INSTANCE;
                log.debugf("Unable to resolve connection default schema : " + ignore.getMessage(), new Object[0]);
            }
        }
    }

    @Override
    public String resolveSchemaName(Connection connection, Dialect dialect) throws SQLException {
        this.determineAppropriateResolverDelegate(connection);
        return this.delegate.resolveSchemaName(connection, dialect);
    }

    public static class SchemaNameResolverFallbackDelegate
    implements SchemaNameResolver {
        public static final SchemaNameResolverFallbackDelegate INSTANCE = new SchemaNameResolverFallbackDelegate();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String resolveSchemaName(Connection connection, Dialect dialect) throws SQLException {
            String command = dialect.getCurrentSchemaCommand();
            if (command == null) {
                throw new HibernateException("Use of DefaultSchemaNameResolver requires Dialect to provide the proper SQL statement/command but provided Dialect [" + dialect.getClass().getName() + "] did not return anything from Dialect#getCurrentSchemaCommand");
            }
            Statement statement = connection.createStatement();
            try {
                String string;
                ResultSet resultSet = statement.executeQuery(dialect.getCurrentSchemaCommand());
                try {
                    string = resultSet.next() ? resultSet.getString(1) : null;
                }
                catch (Throwable throwable) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                return string;
            }
            finally {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    public static class SchemaNameResolverJava17Delegate
    implements SchemaNameResolver {
        private final Method getSchemaMethod;

        public SchemaNameResolverJava17Delegate(Method getSchemaMethod) {
            this.getSchemaMethod = getSchemaMethod;
        }

        @Override
        public String resolveSchemaName(Connection connection, Dialect dialect) throws SQLException {
            try {
                return (String)this.getSchemaMethod.invoke((Object)connection, new Object[0]);
            }
            catch (Exception e) {
                throw new HibernateException("Unable to invoke Connection#getSchema method via reflection", e);
            }
        }
    }
}

