/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.engine.internal.ForeignKeys;
import org.hibernate.engine.jdbc.Size;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.EntityUniqueKey;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.Loadable;
import org.hibernate.type.EntityType;
import org.hibernate.type.ForeignKeyDirection;
import org.hibernate.type.Type;
import org.hibernate.type.TypeFactory;

public class ManyToOneType
extends EntityType {
    private final String propertyName;
    private final boolean ignoreNotFound;
    private boolean isLogicalOneToOne;

    public ManyToOneType(TypeFactory.TypeScope scope, String referencedEntityName) {
        this(scope, referencedEntityName, false);
    }

    public ManyToOneType(TypeFactory.TypeScope scope, String referencedEntityName, boolean lazy) {
        this(scope, referencedEntityName, true, null, null, lazy, true, false, false);
    }

    @Deprecated
    public ManyToOneType(TypeFactory.TypeScope scope, String referencedEntityName, String uniqueKeyPropertyName, boolean lazy, boolean unwrapProxy, boolean isEmbeddedInXML, boolean ignoreNotFound, boolean isLogicalOneToOne) {
        this(scope, referencedEntityName, uniqueKeyPropertyName == null, uniqueKeyPropertyName, null, lazy, unwrapProxy, ignoreNotFound, isLogicalOneToOne);
    }

    public ManyToOneType(TypeFactory.TypeScope scope, String referencedEntityName, boolean referenceToPrimaryKey, String uniqueKeyPropertyName, String propertyName, boolean lazy, boolean unwrapProxy, boolean ignoreNotFound, boolean isLogicalOneToOne) {
        super(scope, referencedEntityName, referenceToPrimaryKey, uniqueKeyPropertyName, !lazy, unwrapProxy);
        this.propertyName = propertyName;
        this.ignoreNotFound = ignoreNotFound;
        this.isLogicalOneToOne = isLogicalOneToOne;
    }

    @Override
    protected boolean isNullable() {
        return this.ignoreNotFound;
    }

    @Override
    public String getPropertyName() {
        return this.propertyName;
    }

    @Override
    public boolean isAlwaysDirtyChecked() {
        return true;
    }

    @Override
    public boolean isOneToOne() {
        return false;
    }

    @Override
    public boolean isLogicalOneToOne() {
        return this.isLogicalOneToOne;
    }

    @Override
    public int getColumnSpan(Mapping mapping) throws MappingException {
        return this.requireIdentifierOrUniqueKeyType(mapping).getColumnSpan(mapping);
    }

    private Type requireIdentifierOrUniqueKeyType(Mapping mapping) {
        Type fkTargetType = this.getIdentifierOrUniqueKeyType(mapping);
        if (fkTargetType == null) {
            throw new MappingException("Unable to determine FK target Type for many-to-one mapping: referenced-entity-name=[" + this.getAssociatedEntityName() + "], referenced-entity-attribute-name=[" + this.getLHSPropertyName() + "]");
        }
        return fkTargetType;
    }

    @Override
    public int[] sqlTypes(Mapping mapping) throws MappingException {
        return this.requireIdentifierOrUniqueKeyType(mapping).sqlTypes(mapping);
    }

    @Override
    public Size[] dictatedSizes(Mapping mapping) throws MappingException {
        return this.requireIdentifierOrUniqueKeyType(mapping).dictatedSizes(mapping);
    }

    @Override
    public Size[] defaultSizes(Mapping mapping) throws MappingException {
        return this.requireIdentifierOrUniqueKeyType(mapping).defaultSizes(mapping);
    }

    @Override
    public void nullSafeSet(PreparedStatement st, Object value, int index, boolean[] settable, SessionImplementor session) throws HibernateException, SQLException {
        this.requireIdentifierOrUniqueKeyType(session.getFactory()).nullSafeSet(st, this.getIdentifier(value, session), index, settable, session);
    }

    @Override
    public void nullSafeSet(PreparedStatement st, Object value, int index, SessionImplementor session) throws HibernateException, SQLException {
        this.requireIdentifierOrUniqueKeyType(session.getFactory()).nullSafeSet(st, this.getIdentifier(value, session), index, session);
    }

    @Override
    public ForeignKeyDirection getForeignKeyDirection() {
        return ForeignKeyDirection.FROM_PARENT;
    }

    @Override
    public Object hydrate(ResultSet rs, String[] names, SessionImplementor session, Object owner) throws HibernateException, SQLException {
        Serializable id = (Serializable)this.getIdentifierOrUniqueKeyType(session.getFactory()).nullSafeGet(rs, names, session, null);
        this.scheduleBatchLoadIfNeeded(id, session);
        return id;
    }

    private void scheduleBatchLoadIfNeeded(Serializable id, SessionImplementor session) throws MappingException {
        EntityPersister persister;
        if (this.uniqueKeyPropertyName == null && id != null && (persister = this.getAssociatedEntityPersister(session.getFactory())).isBatchLoadable()) {
            EntityKey entityKey = session.generateEntityKey(id, persister);
            if (!session.getPersistenceContext().containsEntity(entityKey)) {
                session.getPersistenceContext().getBatchFetchQueue().addBatchLoadableEntityKey(entityKey);
            }
        }
    }

    @Override
    public boolean useLHSPrimaryKey() {
        return false;
    }

    @Override
    public boolean isModified(Object old, Object current, boolean[] checkable, SessionImplementor session) throws HibernateException {
        if (current == null) {
            return old != null;
        }
        if (old == null) {
            return true;
        }
        return this.getIdentifierOrUniqueKeyType(session.getFactory()).isDirty(old, this.getIdentifier(current, session), session);
    }

    @Override
    public Object resolve(Object value, SessionImplementor session, Object owner) throws HibernateException {
        EntityEntry entry;
        Object resolvedValue = super.resolve(value, session, owner);
        if (this.isLogicalOneToOne && value != null && this.getPropertyName() != null && (entry = session.getPersistenceContext().getEntry(owner)) != null) {
            Loadable ownerPersister = (Loadable)session.getFactory().getEntityPersister(entry.getEntityName());
            EntityUniqueKey entityKey = new EntityUniqueKey(ownerPersister.getEntityName(), this.getPropertyName(), value, this, ownerPersister.getEntityMode(), session.getFactory());
            session.getPersistenceContext().addEntity(entityKey, owner);
        }
        return resolvedValue;
    }

    @Override
    public Serializable disassemble(Object value, SessionImplementor session, Object owner) throws HibernateException {
        if (value == null) {
            return null;
        }
        Serializable id = ForeignKeys.getEntityIdentifierIfNotUnsaved(this.getAssociatedEntityName(), value, session);
        if (id == null) {
            throw new AssertionFailure("cannot cache a reference to an object with a null id: " + this.getAssociatedEntityName());
        }
        return this.getIdentifierType(session).disassemble(id, session, owner);
    }

    @Override
    public Object assemble(Serializable oid, SessionImplementor session, Object owner) throws HibernateException {
        Serializable id = this.assembleId(oid, session);
        if (id == null) {
            return null;
        }
        return this.resolveIdentifier(id, session);
    }

    private Serializable assembleId(Serializable oid, SessionImplementor session) {
        return (Serializable)this.getIdentifierType(session).assemble(oid, session, null);
    }

    @Override
    public void beforeAssemble(Serializable oid, SessionImplementor session) {
        this.scheduleBatchLoadIfNeeded(this.assembleId(oid, session), session);
    }

    @Override
    public boolean[] toColumnNullness(Object value, Mapping mapping) {
        boolean[] result = new boolean[this.getColumnSpan(mapping)];
        if (value != null) {
            Arrays.fill(result, true);
        }
        return result;
    }

    @Override
    public boolean isDirty(Object old, Object current, SessionImplementor session) throws HibernateException {
        if (this.isSame(old, current)) {
            return false;
        }
        Object oldid = this.getIdentifier(old, session);
        Object newid = this.getIdentifier(current, session);
        return this.getIdentifierType(session).isDirty(oldid, newid, session);
    }

    @Override
    public boolean isDirty(Object old, Object current, boolean[] checkable, SessionImplementor session) throws HibernateException {
        if (this.isAlwaysDirtyChecked()) {
            return this.isDirty(old, current, session);
        }
        if (this.isSame(old, current)) {
            return false;
        }
        Object oldid = this.getIdentifier(old, session);
        Object newid = this.getIdentifier(current, session);
        return this.getIdentifierType(session).isDirty(oldid, newid, checkable, session);
    }
}

