/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.query.internal.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.persistence.criteria.JoinType;
import org.hibernate.envers.RevisionType;
import org.hibernate.envers.boot.internal.EnversService;
import org.hibernate.envers.configuration.internal.AuditEntitiesConfiguration;
import org.hibernate.envers.exception.AuditException;
import org.hibernate.envers.internal.reader.AuditReaderImplementor;
import org.hibernate.envers.query.AuditAssociationQuery;
import org.hibernate.envers.query.AuditQuery;
import org.hibernate.envers.query.criteria.AuditCriterion;
import org.hibernate.envers.query.internal.impl.AbstractAuditQuery;
import org.hibernate.proxy.HibernateProxy;

public class RevisionsOfEntityQuery
extends AbstractAuditQuery {
    private final boolean selectEntitiesOnly;
    private final boolean selectDeletedEntities;

    public RevisionsOfEntityQuery(EnversService enversService, AuditReaderImplementor versionsReader, Class<?> cls, boolean selectEntitiesOnly, boolean selectDeletedEntities) {
        super(enversService, versionsReader, cls);
        this.selectEntitiesOnly = selectEntitiesOnly;
        this.selectDeletedEntities = selectDeletedEntities;
    }

    public RevisionsOfEntityQuery(EnversService enversService, AuditReaderImplementor versionsReader, Class<?> cls, String entityName, boolean selectEntitiesOnly, boolean selectDeletedEntities) {
        super(enversService, versionsReader, cls, entityName);
        this.selectEntitiesOnly = selectEntitiesOnly;
        this.selectDeletedEntities = selectDeletedEntities;
    }

    private Number getRevisionNumber(Map versionsEntity) {
        AuditEntitiesConfiguration verEntCfg = this.enversService.getAuditEntitiesConfiguration();
        String originalId = verEntCfg.getOriginalIdPropName();
        String revisionPropertyName = verEntCfg.getRevisionFieldName();
        Object revisionInfoObject = ((Map)versionsEntity.get(originalId)).get(revisionPropertyName);
        if (revisionInfoObject instanceof HibernateProxy) {
            return (Number)((HibernateProxy)revisionInfoObject).getHibernateLazyInitializer().getIdentifier();
        }
        return this.enversService.getRevisionInfoNumberReader().getRevisionNumber(revisionInfoObject);
    }

    @Override
    public List list() throws AuditException {
        AuditEntitiesConfiguration verEntCfg = this.enversService.getAuditEntitiesConfiguration();
        if (!this.selectDeletedEntities) {
            this.qb.getRootParameters().addWhereWithParam(verEntCfg.getRevisionTypePropName(), "<>", (Object)RevisionType.DEL);
        }
        for (AuditCriterion criterion : this.criterions) {
            criterion.addToQuery(this.enversService, this.versionsReader, this.aliasToEntityNameMap, "e__", this.qb, this.qb.getRootParameters());
        }
        if (!this.hasProjection() && !this.hasOrder) {
            String revisionPropertyPath = verEntCfg.getRevisionNumberPath();
            this.qb.addOrder("e__", revisionPropertyPath, true);
        }
        if (!this.selectEntitiesOnly) {
            this.qb.addFrom(this.enversService.getAuditEntitiesConfiguration().getRevisionInfoEntityName(), "r", true);
            this.qb.getRootParameters().addWhere(this.enversService.getAuditEntitiesConfiguration().getRevisionNumberPath(), true, "=", "r.id", false);
        }
        List queryResult = this.buildAndExecuteQuery();
        if (this.hasProjection()) {
            return queryResult;
        }
        ArrayList<Object> entities = new ArrayList<Object>();
        String revisionTypePropertyName = verEntCfg.getRevisionTypePropName();
        for (Object resultRow : queryResult) {
            Object revisionData;
            Map versionsEntity;
            if (this.selectEntitiesOnly) {
                versionsEntity = (Map)resultRow;
                revisionData = null;
            } else {
                Object[] arrayResultRow = (Object[])resultRow;
                versionsEntity = (Map)arrayResultRow[0];
                revisionData = arrayResultRow[1];
            }
            Number revision = this.getRevisionNumber(versionsEntity);
            Object entity = this.entityInstantiator.createInstanceFromVersionsEntity(this.entityName, versionsEntity, revision);
            if (!this.selectEntitiesOnly) {
                entities.add(new Object[]{entity, revisionData, versionsEntity.get(revisionTypePropertyName)});
                continue;
            }
            entities.add(entity);
        }
        return entities;
    }

    @Override
    public AuditAssociationQuery<? extends AuditQuery> traverseRelation(String associationName, JoinType joinType) {
        throw new UnsupportedOperationException("Not yet implemented for revisions of entity queries");
    }
}

