/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.infinispan.access;

import java.util.Collection;
import java.util.List;
import org.hibernate.cache.infinispan.access.PutFromLoadValidator;
import org.hibernate.cache.infinispan.util.BeginInvalidationCommand;
import org.hibernate.cache.infinispan.util.CacheCommandInitializer;
import org.hibernate.cache.infinispan.util.EndInvalidationCommand;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.write.InvalidateCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.interceptors.base.BaseCustomInterceptor;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.rpc.ResponseMode;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.rpc.RpcOptions;
import org.infinispan.statetransfer.StateTransferManager;

public class NonTxPutFromLoadInterceptor
extends BaseCustomInterceptor {
    private final String cacheName;
    private final PutFromLoadValidator putFromLoadValidator;
    private CacheCommandInitializer commandInitializer;
    private RpcManager rpcManager;
    private StateTransferManager stateTransferManager;
    private RpcOptions asyncUnordered;

    public NonTxPutFromLoadInterceptor(PutFromLoadValidator putFromLoadValidator, String cacheName) {
        this.putFromLoadValidator = putFromLoadValidator;
        this.cacheName = cacheName;
    }

    @Inject
    public void injectDependencies(CacheCommandInitializer commandInitializer, RpcManager rpcManager, StateTransferManager stateTransferManager) {
        this.commandInitializer = commandInitializer;
        this.rpcManager = rpcManager;
        this.stateTransferManager = stateTransferManager;
    }

    @Start
    public void start() {
        this.asyncUnordered = this.rpcManager.getRpcOptionsBuilder(ResponseMode.ASYNCHRONOUS, DeliverOrder.NONE).build();
    }

    public Object visitInvalidateCommand(InvocationContext ctx, InvalidateCommand command) throws Throwable {
        if (!ctx.isOriginLocal() && command instanceof BeginInvalidationCommand) {
            for (Object key : command.getKeys()) {
                this.putFromLoadValidator.beginInvalidatingKey(((BeginInvalidationCommand)command).getSessionTransactionId(), key);
            }
        }
        return this.invokeNextInterceptor(ctx, (VisitableCommand)command);
    }

    public void broadcastEndInvalidationCommand(Object[] keys, Object sessionTransactionId) {
        assert (sessionTransactionId != null);
        EndInvalidationCommand endInvalidationCommand = this.commandInitializer.buildEndInvalidationCommand(this.cacheName, keys, sessionTransactionId);
        List members = this.stateTransferManager.getCacheTopology().getMembers();
        this.rpcManager.invokeRemotely((Collection)members, (ReplicableCommand)endInvalidationCommand, this.asyncUnordered);
    }
}

