/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.internal.entities.mapper.id;

import java.util.Iterator;
import java.util.List;
import org.hibernate.envers.internal.entities.mapper.id.IdMapper;
import org.hibernate.envers.internal.entities.mapper.id.QueryParameterData;
import org.hibernate.envers.internal.tools.query.Parameters;
import org.hibernate.service.ServiceRegistry;

public abstract class AbstractIdMapper
implements IdMapper {
    private final ServiceRegistry serviceRegistry;

    public AbstractIdMapper(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    @Override
    public ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    private Parameters getParametersToUse(Parameters parameters, List<QueryParameterData> paramDatas) {
        if (paramDatas.size() > 1) {
            return parameters.addSubParameters("and");
        }
        return parameters;
    }

    @Override
    public void addIdsEqualToQuery(Parameters parameters, String prefix1, String prefix2) {
        List<QueryParameterData> paramDatas = this.mapToQueryParametersFromId(null);
        Parameters parametersToUse = this.getParametersToUse(parameters, paramDatas);
        for (QueryParameterData paramData : paramDatas) {
            parametersToUse.addWhere(paramData.getProperty(prefix1), false, "=", paramData.getProperty(prefix2), false);
        }
    }

    @Override
    public void addIdsEqualToQuery(Parameters parameters, String prefix1, IdMapper mapper2, String prefix2) {
        List<QueryParameterData> paramDatas1 = this.mapToQueryParametersFromId(null);
        List<QueryParameterData> paramDatas2 = mapper2.mapToQueryParametersFromId(null);
        Parameters parametersToUse = this.getParametersToUse(parameters, paramDatas1);
        Iterator<QueryParameterData> paramDataIter1 = paramDatas1.iterator();
        Iterator<QueryParameterData> paramDataIter2 = paramDatas2.iterator();
        while (paramDataIter1.hasNext()) {
            QueryParameterData paramData1 = paramDataIter1.next();
            QueryParameterData paramData2 = paramDataIter2.next();
            parametersToUse.addWhere(paramData1.getProperty(prefix1), false, "=", paramData2.getProperty(prefix2), false);
        }
    }

    @Override
    public void addIdEqualsToQuery(Parameters parameters, Object id, String alias, String prefix, boolean equals) {
        List<QueryParameterData> paramDatas = this.mapToQueryParametersFromId(id);
        Parameters parametersToUse = this.getParametersToUse(parameters, paramDatas);
        for (QueryParameterData paramData : paramDatas) {
            if (paramData.getValue() == null) {
                this.handleNullValue(parametersToUse, alias, paramData.getProperty(prefix), equals);
                continue;
            }
            if (alias == null) {
                parametersToUse.addWhereWithParam(paramData.getProperty(prefix), equals ? "=" : "<>", paramData.getValue());
                continue;
            }
            parametersToUse.addWhereWithParam(alias, paramData.getProperty(prefix), equals ? "=" : "<>", paramData.getValue());
        }
    }

    @Override
    public void addNamedIdEqualsToQuery(Parameters parameters, String prefix, boolean equals) {
        List<QueryParameterData> paramDatas = this.mapToQueryParametersFromId(null);
        Parameters parametersToUse = this.getParametersToUse(parameters, paramDatas);
        for (QueryParameterData paramData : paramDatas) {
            parametersToUse.addWhereWithNamedParam(paramData.getProperty(prefix), equals ? "=" : "<>", paramData.getQueryParameterName());
        }
    }

    private void handleNullValue(Parameters parameters, String alias, String propertyName, boolean equals) {
        if (equals) {
            parameters.addNullRestriction(alias, propertyName);
        } else {
            parameters.addNotNullRestriction(alias, propertyName);
        }
    }
}

