/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.internal.reader;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.envers.CrossTypeRevisionChangesReader;
import org.hibernate.envers.RevisionType;
import org.hibernate.envers.boot.internal.EnversService;
import org.hibernate.envers.internal.reader.AuditReaderImplementor;
import org.hibernate.envers.internal.tools.ArgumentsTools;
import org.hibernate.envers.internal.tools.EntityTools;
import org.hibernate.envers.query.criteria.internal.RevisionTypeAuditExpression;
import org.hibernate.envers.tools.Pair;

public class CrossTypeRevisionChangesReaderImpl
implements CrossTypeRevisionChangesReader {
    private final AuditReaderImplementor auditReaderImplementor;
    private final EnversService enversService;

    public CrossTypeRevisionChangesReaderImpl(AuditReaderImplementor auditReaderImplementor, EnversService enversService) {
        this.auditReaderImplementor = auditReaderImplementor;
        this.enversService = enversService;
    }

    @Override
    public List<Object> findEntities(Number revision) throws IllegalStateException, IllegalArgumentException {
        Set<Pair<String, Class>> entityTypes = this.findEntityTypes(revision);
        ArrayList<Object> result = new ArrayList<Object>();
        for (Pair<String, Class> type : entityTypes) {
            result.addAll(this.auditReaderImplementor.createQuery().forEntitiesModifiedAtRevision(type.getSecond(), type.getFirst(), revision).getResultList());
        }
        return result;
    }

    @Override
    public List<Object> findEntities(Number revision, RevisionType revisionType) throws IllegalStateException, IllegalArgumentException {
        Set<Pair<String, Class>> entityTypes = this.findEntityTypes(revision);
        ArrayList<Object> result = new ArrayList<Object>();
        for (Pair<String, Class> type : entityTypes) {
            result.addAll(this.auditReaderImplementor.createQuery().forEntitiesModifiedAtRevision(type.getSecond(), type.getFirst(), revision).add(new RevisionTypeAuditExpression(null, (Object)revisionType, "=")).getResultList());
        }
        return result;
    }

    @Override
    public Map<RevisionType, List<Object>> findEntitiesGroupByRevisionType(Number revision) throws IllegalStateException, IllegalArgumentException {
        Set<Pair<String, Class>> entityTypes = this.findEntityTypes(revision);
        HashMap<RevisionType, List<Object>> result = new HashMap<RevisionType, List<Object>>();
        for (RevisionType revisionType : RevisionType.values()) {
            result.put(revisionType, new ArrayList());
            for (Pair<String, Class> type : entityTypes) {
                List list = this.auditReaderImplementor.createQuery().forEntitiesModifiedAtRevision(type.getSecond(), type.getFirst(), revision).add(new RevisionTypeAuditExpression(null, (Object)revisionType, "=")).getResultList();
                ((List)result.get((Object)revisionType)).addAll(list);
            }
        }
        return result;
    }

    @Override
    public Set<Pair<String, Class>> findEntityTypes(Number revision) throws IllegalStateException, IllegalArgumentException {
        Set<String> entityNames;
        ArgumentsTools.checkNotNull(revision, "Entity revision");
        ArgumentsTools.checkPositive(revision, "Entity revision");
        this.checkSession();
        Session session = this.auditReaderImplementor.getSession();
        SessionImplementor sessionImplementor = this.auditReaderImplementor.getSessionImplementor();
        HashSet<Number> revisions = new HashSet<Number>(1);
        revisions.add(revision);
        Criteria query = this.enversService.getRevisionInfoQueryCreator().getRevisionsQuery(session, revisions);
        Object revisionInfo = query.uniqueResult();
        if (revisionInfo != null && (entityNames = this.enversService.getModifiedEntityNamesReader().getModifiedEntityNames(revisionInfo)) != null) {
            HashSet<Pair<String, Class>> result = new HashSet<Pair<String, Class>>();
            for (String entityName : entityNames) {
                result.add(Pair.make(entityName, EntityTools.getEntityClass(sessionImplementor, session, entityName)));
            }
            return result;
        }
        return Collections.EMPTY_SET;
    }

    private void checkSession() {
        if (!this.auditReaderImplementor.getSession().isOpen()) {
            throw new IllegalStateException("The associated entity manager is closed!");
        }
    }
}

