/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.infinispan.access;

import org.hibernate.cache.CacheException;
import org.hibernate.cache.infinispan.access.InvalidationCacheAccessDelegate;
import org.hibernate.cache.infinispan.access.PutFromLoadValidator;
import org.hibernate.cache.infinispan.impl.BaseRegion;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.engine.spi.SharedSessionContractImplementor;

public class NonTxInvalidationCacheAccessDelegate
extends InvalidationCacheAccessDelegate {
    public NonTxInvalidationCacheAccessDelegate(BaseRegion region, PutFromLoadValidator validator) {
        super(region, validator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean insert(SharedSessionContractImplementor session, Object key, Object value, Object version) throws CacheException {
        if (!this.region.checkValid()) {
            return false;
        }
        this.putValidator.setCurrentSession(session);
        try {
            this.writeCache.put(key, value);
        }
        finally {
            this.putValidator.resetCurrentSession();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean update(SharedSessionContractImplementor session, Object key, Object value, Object currentVersion, Object previousVersion) throws CacheException {
        this.putValidator.setCurrentSession(session);
        try {
            this.writeCache.put(key, value);
        }
        finally {
            this.putValidator.resetCurrentSession();
        }
        return true;
    }

    @Override
    public boolean afterInsert(SharedSessionContractImplementor session, Object key, Object value, Object version) {
        return false;
    }

    @Override
    public boolean afterUpdate(SharedSessionContractImplementor session, Object key, Object value, Object currentVersion, Object previousVersion, SoftLock lock) {
        return false;
    }

    @Override
    public void removeAll() throws CacheException {
        try {
            if (!this.putValidator.beginInvalidatingRegion()) {
                log.failedInvalidateRegion(this.region.getName());
            }
            this.cache.clear();
        }
        finally {
            this.putValidator.endInvalidatingRegion();
        }
    }
}

