/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa.internal;

import java.io.Serializable;
import javax.persistence.PersistenceUnitUtil;
import javax.persistence.spi.LoadState;
import org.hibernate.Hibernate;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.jpa.internal.util.PersistenceUtilHelper;
import org.hibernate.persister.entity.EntityPersister;
import org.jboss.logging.Logger;

public class PersistenceUnitUtilImpl
implements PersistenceUnitUtil,
Serializable {
    private static final Logger log = Logger.getLogger(PersistenceUnitUtilImpl.class);
    private final SessionFactoryImplementor sessionFactory;
    private final transient PersistenceUtilHelper.MetadataCache cache = new PersistenceUtilHelper.MetadataCache();

    public PersistenceUnitUtilImpl(SessionFactoryImplementor sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public boolean isLoaded(Object entity, String attributeName) {
        log.debug((Object)"PersistenceUnitUtil#isLoaded is not always accurate; consider using EntityManager#contains instead");
        LoadState state = PersistenceUtilHelper.isLoadedWithoutReference(entity, attributeName, this.cache);
        if (state == LoadState.LOADED) {
            return true;
        }
        if (state == LoadState.NOT_LOADED) {
            return false;
        }
        return PersistenceUtilHelper.isLoadedWithReference(entity, attributeName, this.cache) != LoadState.NOT_LOADED;
    }

    public boolean isLoaded(Object entity) {
        log.debug((Object)"PersistenceUnitUtil#isLoaded is not always accurate; consider using EntityManager#contains instead");
        return PersistenceUtilHelper.isLoaded(entity) != LoadState.NOT_LOADED;
    }

    public Object getIdentifier(Object entity) {
        Class entityClass = Hibernate.getClass(entity);
        EntityPersister persister = this.sessionFactory.getMetamodel().entityPersister(entityClass);
        if (persister == null) {
            throw new IllegalArgumentException(entityClass + " is not an entity");
        }
        return persister.getIdentifier(entity);
    }
}

