/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.internal;

import javax.persistence.TemporalType;
import org.hibernate.query.internal.BindingTypeHelper;
import org.hibernate.query.spi.QueryParameterBinding;
import org.hibernate.query.spi.QueryParameterBindingTypeResolver;
import org.hibernate.type.Type;

public class QueryParameterBindingImpl<T>
implements QueryParameterBinding<T> {
    private final QueryParameterBindingTypeResolver typeResolver;
    private boolean isBound;
    private Type bindType;
    private T bindValue;

    public QueryParameterBindingImpl(Type type, QueryParameterBindingTypeResolver typeResolver) {
        this.bindType = type;
        this.typeResolver = typeResolver;
    }

    @Override
    public boolean isBound() {
        return this.isBound;
    }

    @Override
    public T getBindValue() {
        return this.bindValue;
    }

    @Override
    public Type getBindType() {
        return this.bindType;
    }

    @Override
    public void setBindValue(T value) {
        this.isBound = true;
        this.bindValue = value;
        if (this.bindType == null) {
            this.bindType = this.typeResolver.resolveParameterBindType(value);
        }
    }

    @Override
    public void setBindValue(T value, Type clarifiedType) {
        this.setBindValue(value);
        if (clarifiedType != null) {
            this.bindType = clarifiedType;
        }
    }

    @Override
    public void setBindValue(T value, TemporalType clarifiedTemporalType) {
        this.setBindValue(value);
        this.bindType = BindingTypeHelper.INSTANCE.determineTypeForTemporalType(clarifiedTemporalType, this.bindType, value);
    }
}

