/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.infinispan.access;

import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.hibernate.cache.infinispan.impl.BaseTransactionalDataRegion;
import org.hibernate.cache.infinispan.util.InvocationAfterCompletion;
import org.hibernate.cache.infinispan.util.Tombstone;
import org.hibernate.resource.transaction.spi.TransactionCoordinator;
import org.infinispan.AdvancedCache;

public class TombstoneSynchronization<K>
extends InvocationAfterCompletion {
    private final UUID uuid = UUID.randomUUID();
    private final BaseTransactionalDataRegion region;
    private final K key;

    public TombstoneSynchronization(TransactionCoordinator tc, AdvancedCache cache, boolean requiresTransaction, BaseTransactionalDataRegion region, K key) {
        super(tc, cache, requiresTransaction);
        this.key = key;
        this.region = region;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public K getKey() {
        return this.key;
    }

    @Override
    public void beforeCompletion() {
    }

    @Override
    public void invoke(boolean success, AdvancedCache cache) {
        Tombstone tombstone = new Tombstone(this.uuid, this.region.nextTimestamp(), true);
        cache.put(this.key, (Object)tombstone, this.region.getTombstoneExpiration(), TimeUnit.MILLISECONDS);
    }
}

